/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.library;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import org.jsoup.Jsoup;

public class CheckNewAppVersion
extends AsyncTask<Void, Void, Result> {
    private static final String REFERRER = "http://www.google.com";
    private static final String DIV = "div[itemprop=softwareVersion]";
    private static final String USER_AGENT = "Mozilla/5.0 (Windows; U; WindowsNT 5.1; en-US; rv1.8.1.6) Gecko/20070725 Firefox/2.0.0.6";
    private static final String PLAY_STORE_LINK = "http://play.google.com/store/apps/details?id=%s&hl=en";
    private Result result;
    private Context context;
    private ITaskComplete listener;

    public CheckNewAppVersion(Context context) {
        this.context = context;
        this.result = new Result(context);
    }

    public String getExternalAppLink() {
        return String.format(PLAY_STORE_LINK, this.context.getPackageName());
    }

    protected Result doInBackground(Void ... params) {
        try {
            PackageInfo info = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            this.result.setOldVersionCode(info.versionName);
        }
        catch (PackageManager.NameNotFoundException info) {
            // empty catch block
        }
        try {
            String newVersion = Jsoup.connect((String)this.getExternalAppLink()).timeout(30000).userAgent(USER_AGENT).referrer(REFERRER).get().select(DIV).first().ownText();
            this.result.setNewVersionCode(newVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.result;
    }

    protected void onPostExecute(Result result) {
        if (this.listener != null) {
            this.listener.onTaskComplete(result);
        }
    }

    public CheckNewAppVersion setOnTaskCompleteListener(ITaskComplete listener) {
        this.listener = listener;
        return this;
    }

    public class Result {
        private Context context;
        private String newVersionCode;
        private String oldVersionCode;

        public boolean hasNewVersion() {
            return this.onlyNumbers(this.getOldVersionCode()) < this.onlyNumbers(this.getNewVersionCode());
        }

        public String getNewVersionCode() {
            return this.newVersionCode;
        }

        public String getOldVersionCode() {
            return this.oldVersionCode;
        }

        public void setNewVersionCode(String newVersionCode) {
            this.newVersionCode = newVersionCode;
        }

        public void setOldVersionCode(String oldVersionCode) {
            this.oldVersionCode = oldVersionCode;
        }

        public Context getContext() {
            return this.context;
        }

        public void openUpdateLink() {
            this.context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)CheckNewAppVersion.this.getExternalAppLink())));
        }

        public Result(Context context, String newVersionCode, String oldVersionCode) {
            this.context = context;
            this.newVersionCode = newVersionCode;
            this.oldVersionCode = oldVersionCode;
        }

        public Result(Context context) {
            this(context, "", "");
        }

        public long onlyNumbers(String s) {
            String val = s.replaceAll("\\D+", "");
            try {
                return Long.valueOf(val);
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }

    public static interface ITaskComplete {
        public void onTaskComplete(Result var1);
    }
}

