/*
 * Decompiled with CFR 0.152.
 */
package math.stats.distributions;

import math.stats.distributions.Distribution;
import smile.stat.distribution.GaussianDistribution;

public final class Normal
implements Distribution {
    private final smile.stat.distribution.Distribution dist;
    private final double mean;
    private final double stdev;

    public Normal(double mean, double stdev) {
        this.dist = new GaussianDistribution(mean, stdev);
        this.mean = mean;
        this.stdev = stdev;
    }

    public Normal() {
        this(0.0, 1.0);
    }

    @Override
    public final double rand() {
        return this.dist.rand();
    }

    @Override
    public final double quantile(double prob) {
        return this.dist.quantile(prob);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Normal normal = (Normal)o;
        if (Double.compare(normal.mean, this.mean) != 0) {
            return false;
        }
        return Double.compare(normal.stdev, this.stdev) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.mean);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.stdev);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return this.dist.toString();
    }
}

