/*
 * Decompiled with CFR 0.152.
 */
package math.stats;

import java.util.Arrays;
import math.operations.Operators;

public final class Statistics {
    private Statistics() {
    }

    public static double sumOf(double[] data) {
        double sum = 0.0;
        for (double element : data) {
            sum += element;
        }
        return sum;
    }

    public static double meanOf(double[] data) {
        double sum = Statistics.sumOf(data);
        return sum / (double)data.length;
    }

    public static double varianceOf(double[] data) {
        int n = data.length;
        return Statistics.sumOfSquaredDifferences(data, Statistics.meanOf(data)) / (double)(n - 1);
    }

    public static double stdDeviationOf(double[] data) {
        return Math.sqrt(Statistics.varianceOf(data));
    }

    public static double sumOfSquared(double[] data) {
        return Statistics.sumOf(Statistics.squared(data));
    }

    static double sumOfSquaredDifferences(double[] data, double point) {
        return Statistics.sumOf(Statistics.squared(Statistics.differences(data, point)));
    }

    static double[] squared(double[] data) {
        double[] squared = new double[data.length];
        for (int i = 0; i < squared.length; ++i) {
            squared[i] = data[i] * data[i];
        }
        return squared;
    }

    static double[] differences(double[] data, double point) {
        double[] differenced = new double[data.length];
        for (int i = 0; i < differenced.length; ++i) {
            differenced[i] = data[i] - point;
        }
        return differenced;
    }

    public static double covarianceOf(double[] data, double[] data2) {
        return Statistics.sumOf(Operators.productOf(Statistics.differences(data, Statistics.meanOf(data)), Statistics.differences(data2, Statistics.meanOf(data2)))) / (double)(data.length - 1);
    }

    public static double correlationOf(double[] data, double[] data2) {
        return Statistics.covarianceOf(data, data2) / (Statistics.stdDeviationOf(data) * Statistics.stdDeviationOf(data2));
    }

    public static double medianOf(double[] data) {
        double[] sorted = (double[])data.clone();
        Arrays.sort(sorted);
        if (sorted.length % 2 == 0) {
            return (sorted[sorted.length / 2 - 1] + sorted[sorted.length / 2]) / 2.0;
        }
        return sorted[(sorted.length - 1) / 2];
    }
}

