/*
 * Decompiled with CFR 0.152.
 */
package math.linear.doubles;

import java.util.Arrays;
import math.linear.doubles.Matrix;
import math.stats.Statistics;

public final class Vector {
    private final double[] elements;

    public Vector(double ... elements) {
        this.elements = (double[])elements.clone();
    }

    public static Vector from(double ... elements) {
        return new Vector(elements);
    }

    public double[] elements() {
        return (double[])this.elements.clone();
    }

    public double at(int i) {
        return this.elements[i];
    }

    public int size() {
        return this.elements.length;
    }

    public Vector plus(Vector other) {
        if (other.elements().length == 0) {
            return this;
        }
        double[] summed = new double[this.size()];
        for (int i = 0; i < summed.length; ++i) {
            summed[i] = this.elements[i] + other.elements[i];
        }
        return new Vector(summed);
    }

    public Vector minus(Vector other) {
        double[] differenced = new double[this.size()];
        for (int i = 0; i < differenced.length; ++i) {
            differenced[i] = this.elements[i] - other.elements[i];
        }
        return new Vector(differenced);
    }

    public Vector minus(double scalar) {
        double[] differenced = new double[this.size()];
        for (int i = 0; i < differenced.length; ++i) {
            differenced[i] = this.elements[i] - scalar;
        }
        return new Vector(differenced);
    }

    public Vector scaledBy(double alpha) {
        double[] scaled = new double[this.size()];
        for (int i = 0; i < scaled.length; ++i) {
            scaled[i] = alpha * this.elements[i];
        }
        return new Vector(scaled);
    }

    public double dotProduct(Vector other) {
        if (other.elements.length > 0) {
            double product = 0.0;
            for (int i = 0; i < this.elements.length; ++i) {
                product += this.elements[i] * other.elements[i];
            }
            return product;
        }
        throw new IllegalArgumentException("The dot product is undefined for zero length vectors");
    }

    public Matrix outerProduct(Vector other) {
        double[] product = new double[this.elements.length * other.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < other.elements.length; ++j) {
                product[i * other.elements.length + j] = this.elements[i] * other.elements[j];
            }
        }
        return new Matrix(this.elements.length, other.elements.length, product);
    }

    Vector axpy(Vector other, double alpha) {
        double[] result = new double[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = alpha * this.elements[i] + other.elements[i];
        }
        return new Vector(result);
    }

    public double norm() {
        return Math.sqrt(this.dotProduct(this));
    }

    public double sum() {
        return Statistics.sumOf(this.elements);
    }

    public double sumOfSquares() {
        return Statistics.sumOfSquared(this.elements);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.elements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector other = (Vector)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    public String toString() {
        return "elements: " + Arrays.toString(this.elements);
    }
}

