/*
 * Decompiled with CFR 0.152.
 */
package math.linear;

import java.util.ArrayList;
import java.util.List;
import math.Complex;
import math.FieldElement;
import math.linear.FieldVector;

final class ComplexVectors {
    private ComplexVectors() {
    }

    static FieldVector<Complex> linearCombination(List<FieldVector<Complex>> vectors, List<Complex> scalars) {
        FieldVector<Complex> result = ComplexVectors.zeroVector(scalars.size());
        for (int i = 0; i < vectors.size(); ++i) {
            result = result.plus(vectors.get(i).scaledBy((Complex)((FieldElement)scalars.get(i))));
        }
        return result;
    }

    static FieldVector<Complex> axpy(FieldVector<Complex> x, FieldVector<Complex> y, Complex alpha) {
        return x.scaledBy(alpha).plus(y);
    }

    static FieldVector<Complex> zeroVector(int size) {
        ArrayList<Complex> zeros = new ArrayList<Complex>(size);
        for (int i = 0; i < size; ++i) {
            zeros.add(new Complex(0.0, 0.0));
        }
        return new FieldVector<Complex>((List<Complex>)zeros);
    }
}

