/*
 * Decompiled with CFR 0.152.
 */
package com.noveogroup.android.log;

import android.util.Log;
import com.noveogroup.android.log.Handler;
import com.noveogroup.android.log.Logger;
import com.noveogroup.android.log.Pattern;
import com.noveogroup.android.log.Utils;

public class PatternHandler
implements Handler {
    private final Logger.Level level;
    private final String tagPattern;
    private final String messagePattern;
    private final Pattern compiledTagPattern;
    private final Pattern compiledMessagePattern;

    public PatternHandler(Logger.Level level, String tagPattern, String messagePattern) {
        this.level = level;
        this.tagPattern = tagPattern;
        this.compiledTagPattern = Pattern.compile(tagPattern);
        this.messagePattern = messagePattern;
        this.compiledMessagePattern = Pattern.compile(messagePattern);
    }

    public Logger.Level getLevel() {
        return this.level;
    }

    public String getTagPattern() {
        return this.tagPattern;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return this.level != null && level != null && this.level.includes(level);
    }

    @Override
    public void print(String loggerName, Logger.Level level, Throwable throwable, String message) throws IllegalArgumentException {
        if (this.isEnabled(level)) {
            String messageHead;
            String messageBody = message == null ? (throwable == null ? "" : Log.getStackTraceString((Throwable)throwable)) : (throwable == null ? message : message + '\n' + Log.getStackTraceString((Throwable)throwable));
            StackTraceElement caller = null;
            if (this.compiledTagPattern != null && this.compiledTagPattern.isCallerNeeded() || this.compiledMessagePattern != null && this.compiledMessagePattern.isCallerNeeded()) {
                caller = Utils.getCaller();
            }
            String tag = this.compiledTagPattern == null ? "" : this.compiledTagPattern.apply(caller, loggerName, level);
            String string = messageHead = this.compiledMessagePattern == null ? "" : this.compiledMessagePattern.apply(caller, loggerName, level);
            if (messageHead.length() > 0 && !Character.isWhitespace(messageHead.charAt(0))) {
                messageHead = messageHead + " ";
            }
            Log.println((int)level.intValue(), (String)tag, (String)(messageHead + messageBody));
        }
    }

    @Override
    public void print(String loggerName, Logger.Level level, Throwable throwable, String messageFormat, Object ... args) throws IllegalArgumentException {
        if (this.isEnabled(level)) {
            if (messageFormat == null && args != null && args.length > 0) {
                throw new IllegalArgumentException("message format is not set but arguments are presented");
            }
            this.print(loggerName, level, throwable, messageFormat == null ? null : String.format(messageFormat, args));
        }
    }
}

