/*
 * Decompiled with CFR 0.152.
 */
package com.jp.androidlogger;

import android.util.Log;
import com.jp.androidlogger.AndroidLoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class AndroidLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -1227274521521287937L;
    private AndroidLoggerFactory androidLoggerFactory;

    protected AndroidLogger(String name, AndroidLoggerFactory androidLoggerFactory) {
        this.name = name;
        this.androidLoggerFactory = androidLoggerFactory;
    }

    void setName(String tagName) {
        this.name = tagName;
    }

    public boolean isTraceEnabled() {
        return this.androidLoggerFactory.isEnabled(2);
    }

    public void trace(String msg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.log(2, msg, null);
    }

    public void trace(String format, Object arg) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.logVerbose(MessageFormatter.format((String)format, (Object)arg));
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.logVerbose(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void trace(String format, Object ... arguments) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.logVerbose(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
    }

    public void trace(String msg, Throwable t) {
        if (!this.isTraceEnabled()) {
            return;
        }
        Log.v((String)this.name, (String)msg, (Throwable)t);
    }

    public boolean isDebugEnabled() {
        return this.androidLoggerFactory.isEnabled(3);
    }

    public void debug(String msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.log(3, msg, null);
    }

    public void debug(String format, Object arg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.logDebug(MessageFormatter.format((String)format, (Object)arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.logDebug(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void debug(String format, Object ... arguments) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.logDebug(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
    }

    public void debug(String msg, Throwable t) {
        if (!this.isDebugEnabled()) {
            return;
        }
        Log.d((String)this.name, (String)msg, (Throwable)t);
    }

    public boolean isInfoEnabled() {
        return this.androidLoggerFactory.isEnabled(4);
    }

    public void info(String msg) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.log(4, msg, null);
    }

    public void info(String format, Object arg) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.logInfo(MessageFormatter.format((String)format, (Object)arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.logInfo(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void info(String format, Object ... arguments) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.logInfo(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
    }

    public void info(String msg, Throwable t) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.log(4, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.androidLoggerFactory.isEnabled(5);
    }

    public void warn(String msg) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.log(5, msg, null);
    }

    public void warn(String format, Object arg) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.logWarning(MessageFormatter.format((String)format, (Object)arg));
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.logWarning(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void warn(String format, Object ... arguments) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.logWarning(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
    }

    public void warn(String msg, Throwable t) {
        if (!this.isWarnEnabled()) {
            return;
        }
        Log.w((String)this.name, (String)msg, (Throwable)t);
    }

    public boolean isErrorEnabled() {
        return this.androidLoggerFactory.isEnabled(6);
    }

    public void error(String msg) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.log(6, msg, null);
    }

    public void error(String format, Object arg) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.logError(MessageFormatter.format((String)format, (Object)arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.logError(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
    }

    public void error(String format, Object ... arguments) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.logError(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
    }

    public void error(String msg, Throwable t) {
        if (!this.isErrorEnabled()) {
            return;
        }
        Log.e((String)this.name, (String)msg, (Throwable)t);
    }

    private void logVerbose(FormattingTuple ft) {
        this.log(2, ft.getMessage(), ft.getThrowable());
    }

    private void logDebug(FormattingTuple ft) {
        this.log(3, ft.getMessage(), ft.getThrowable());
    }

    private void logInfo(FormattingTuple ft) {
        this.log(4, ft.getMessage(), ft.getThrowable());
    }

    private void logWarning(FormattingTuple ft) {
        this.log(5, ft.getMessage(), ft.getThrowable());
    }

    private void logError(FormattingTuple ft) {
        this.log(6, ft.getMessage(), ft.getThrowable());
    }

    private void log(int logLevel, String message, Throwable tr) {
        if (tr != null) {
            message = message + '\n' + Log.getStackTraceString((Throwable)tr);
        }
        String origMessage = null;
        if (this.androidLoggerFactory.isLongLoggingEnabled() && message.length() > this.androidLoggerFactory.getMaxCharactersPerLine()) {
            origMessage = message;
            message = message.substring(0, this.androidLoggerFactory.getMaxCharactersPerLine());
        }
        switch (logLevel) {
            case 2: {
                Log.v((String)this.name, (String)message);
                break;
            }
            case 3: {
                Log.d((String)this.name, (String)message);
                break;
            }
            case 4: {
                Log.i((String)this.name, (String)message);
                break;
            }
            case 5: {
                Log.w((String)this.name, (String)message);
                break;
            }
            case 6: {
                Log.e((String)this.name, (String)message);
            }
        }
        this.androidLoggerFactory.logToFile(logLevel, this.name, message);
        if (origMessage != null) {
            this.log(logLevel, origMessage.substring(this.androidLoggerFactory.getMaxCharactersPerLine()), null);
        }
    }
}

