/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.commons;

import com.joutvhu.dynamic.commons.DynamicQueryTemplate;
import com.joutvhu.dynamic.commons.util.DynamicTemplateResolver;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class DynamicQueryTemplateProvider
implements ResourceLoaderAware,
InitializingBean {
    protected String encoding = "UTF-8";
    protected String templateLocation = "classpath:/query";
    protected String suffix = ".dsql";
    protected ResourceLoader resourceLoader;

    public abstract DynamicQueryTemplate createTemplate(String var1, String var2);

    public abstract DynamicQueryTemplate findTemplate(String var1);

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected abstract void putTemplate(String var1, String var2);

    private String getTemplateLocationPattern() {
        String pattern;
        String string = pattern = StringUtils.isNotBlank((CharSequence)this.templateLocation) ? this.templateLocation : "classpath:";
        if (!pattern.endsWith(this.suffix)) {
            if (!pattern.endsWith("/**/*")) {
                pattern = pattern + "/**/*";
            }
            pattern = pattern + this.suffix;
        }
        return pattern;
    }

    public void afterPropertiesSet() throws Exception {
        Resource[] resources;
        if (this.suffix == null) {
            return;
        }
        String pattern = this.getTemplateLocationPattern();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        for (Resource resource : resources = resourcePatternResolver.getResources(pattern)) {
            DynamicTemplateResolver.of(resource).encoding(this.encoding).load(this::putTemplate);
        }
    }
}

