/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.context;

import com.github.jknack.handlebars.ValueResolver;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;

public abstract class MemberValueResolver<M extends Member>
implements ValueResolver {
    private final Map<CacheKey, Object> cache = new ConcurrentHashMap<CacheKey, Object>();

    @Override
    public final Object resolve(Object context, String name) {
        CacheKey key = this.key(context, name);
        Object value = this.cache.get(key);
        if (value == UNRESOLVED) {
            return value;
        }
        Member member = (Member)value;
        if (member == null) {
            member = this.find(context.getClass(), name);
            if (member == null) {
                this.cache.put(key, UNRESOLVED);
                return UNRESOLVED;
            }
            if (member instanceof AccessibleObject) {
                ((AccessibleObject)((Object)member)).setAccessible(true);
            }
            this.cache.put(key, member);
        }
        return this.invokeMember(member, context);
    }

    @Override
    public Object resolve(Object context) {
        return UNRESOLVED;
    }

    protected final M find(Class<?> clazz, String name) {
        Set<M> members = this.membersFromCache(clazz);
        for (Member member : members) {
            if (!this.matches(member, name)) continue;
            return (M)member;
        }
        return null;
    }

    protected abstract Object invokeMember(M var1, Object var2);

    public abstract boolean matches(M var1, String var2);

    protected boolean isPublic(M member) {
        return Modifier.isPublic(member.getModifiers());
    }

    protected boolean isPrivate(M member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    protected boolean isProtected(M member) {
        return Modifier.isProtected(member.getModifiers());
    }

    protected boolean isStatic(M member) {
        return Modifier.isStatic(member.getModifiers());
    }

    private CacheKey key(Object context, String name) {
        return new CacheKey(context.getClass(), name);
    }

    protected abstract Set<M> members(Class<?> var1);

    protected Set<M> membersFromCache(Class<?> clazz) {
        CacheKey key = new CacheKey(clazz);
        Set<M> members = (Set<M>)this.cache.get(key);
        if (members == null) {
            members = this.members(clazz);
            this.cache.put(key, members);
        }
        return members;
    }

    @Override
    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        Validate.notNull((Object)context, (String)"The context is required.", (Object[])new Object[0]);
        if (context instanceof Map) {
            return Collections.emptySet();
        }
        if (context instanceof Collection) {
            return Collections.emptySet();
        }
        Set<M> members = this.membersFromCache(context.getClass());
        LinkedHashMap<String, Object> propertySet = new LinkedHashMap<String, Object>();
        for (Member member : members) {
            String name = this.memberName(member);
            propertySet.put(name, this.resolve(context, name));
        }
        return propertySet.entrySet();
    }

    protected abstract String memberName(M var1);

    private static class CacheKey {
        private final Class<?> clazz;
        private final String name;

        public CacheKey(Class<?> clazz) {
            this(clazz, null);
        }

        public CacheKey(Class<?> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.clazz, this.name});
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return CacheKey.equal(this.clazz, other.clazz) && CacheKey.equal(this.name, other.name);
            }
            return false;
        }

        private static boolean equal(Object first, Object second) {
            return first == second || first != null && first.equals(second);
        }
    }
}

