/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.BaseTemplate;
import com.github.jknack.handlebars.internal.Block;
import com.github.jknack.handlebars.internal.ForwardingTemplate;
import com.github.jknack.handlebars.internal.HbsParser;
import com.github.jknack.handlebars.internal.HbsParserBaseVisitor;
import com.github.jknack.handlebars.internal.Partial;
import com.github.jknack.handlebars.internal.TemplateList;
import com.github.jknack.handlebars.internal.Text;
import com.github.jknack.handlebars.internal.Variable;
import com.github.jknack.handlebars.io.TemplateSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

abstract class TemplateBuilder
extends HbsParserBaseVisitor<Object> {
    private Handlebars handlebars;
    private TemplateSource source;
    private Boolean hasTag;
    protected StringBuilder line = new StringBuilder();

    public TemplateBuilder(Handlebars handlebars, TemplateSource source) {
        this.handlebars = (Handlebars)Validate.notNull((Object)handlebars, (String)"The handlebars can't be null.", (Object[])new Object[0]);
        this.source = (TemplateSource)Validate.notNull((Object)source, (String)"The template source is requied.", (Object[])new Object[0]);
    }

    public Template visit(ParseTree tree) {
        return (Template)super.visit(tree);
    }

    @Override
    public Template visitBlock(HbsParser.BlockContext ctx) {
        Template unless;
        String nameEnd;
        String nameStart = ctx.nameStart.getText();
        if (!nameStart.equals(nameEnd = ctx.nameEnd.getText())) {
            this.reportError(null, ctx.nameEnd.getLine(), ctx.nameEnd.getCharPositionInLine(), String.format("found: '%s', expected: '%s'", nameEnd, nameStart));
        }
        this.hasTag(true);
        Block block = new Block(this.handlebars, nameStart, false, this.params(ctx.param()), this.hash(ctx.hash()));
        block.filename(this.source.filename());
        block.position(ctx.nameStart.getLine(), ctx.nameStart.getCharPositionInLine());
        String startDelim = ctx.start.getText();
        block.startDelimiter(startDelim.substring(0, startDelim.length() - 1));
        block.endDelimiter(ctx.stop.getText());
        Template body = this.visitBody(ctx.thenBody);
        if (body != null) {
            block.body(body);
        }
        if (ctx.unlessBody != null && (unless = this.visitBody(ctx.unlessBody)) != null) {
            block.inverse(unless);
        }
        this.hasTag(true);
        return block;
    }

    @Override
    public Template visitUnless(HbsParser.UnlessContext ctx) {
        this.hasTag(true);
        Block block = new Block(this.handlebars, ctx.nameStart.getText(), true, Collections.<Object>emptyList(), Collections.<String, Object>emptyMap());
        block.filename(this.source.filename());
        block.position(ctx.nameStart.getLine(), ctx.nameStart.getCharPositionInLine());
        String startDelim = ctx.start.getText();
        block.startDelimiter(startDelim.substring(0, startDelim.length() - 1));
        block.endDelimiter(ctx.stop.getText());
        Template body = this.visitBody(ctx.body());
        if (body != null) {
            block.body(body);
        }
        this.hasTag(true);
        return block;
    }

    @Override
    public Template visitVar(HbsParser.VarContext ctx) {
        this.hasTag(false);
        return this.newVar(ctx.QID().getSymbol(), TagType.VAR, this.params(ctx.param()), this.hash(ctx.hash()), ctx.start.getText(), ctx.stop.getText());
    }

    @Override
    public Template visitTvar(HbsParser.TvarContext ctx) {
        this.hasTag(false);
        return this.newVar(ctx.QID().getSymbol(), TagType.TRIPLE_VAR, this.params(ctx.param()), this.hash(ctx.hash()), ctx.start.getText(), ctx.stop.getText());
    }

    @Override
    public Template visitAmpvar(HbsParser.AmpvarContext ctx) {
        this.hasTag(false);
        return this.newVar(ctx.QID().getSymbol(), TagType.AMP_VAR, this.params(ctx.param()), this.hash(ctx.hash()), ctx.start.getText(), ctx.stop.getText());
    }

    private Template newVar(Token name, TagType varType, List<Object> params, Map<String, Object> hash, String startDelimiter, String endDelimiter) {
        Helper helperMissing;
        String varName = name.getText();
        Helper helper = this.handlebars.helper(varName);
        if (helper == null && (params.size() > 0 || hash.size() > 0) && (helperMissing = this.handlebars.helper("helperMissing")) == null) {
            this.reportError(null, name.getLine(), name.getCharPositionInLine(), "could not find helper: '" + varName + "'");
        }
        return new Variable(this.handlebars, varName, varType, params, hash).startDelimiter(startDelimiter).endDelimiter(endDelimiter).filename(this.source.filename()).position(name.getLine(), name.getCharPositionInLine());
    }

    private Map<String, Object> hash(List<HbsParser.HashContext> ctx) {
        if (ctx == null || ctx.size() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (HbsParser.HashContext hc : ctx) {
            result.put(hc.QID().getText(), super.visit((ParseTree)hc.hashValue()));
        }
        return result;
    }

    private List<Object> params(List<HbsParser.ParamContext> params) {
        if (params == null || params.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (HbsParser.ParamContext param : params) {
            result.add(super.visit((ParseTree)param));
        }
        return result;
    }

    @Override
    public Object visitBoolParam(HbsParser.BoolParamContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Object visitBoolHash(HbsParser.BoolHashContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Object visitCharsHash(HbsParser.CharsHashContext ctx) {
        return ctx.getText().replace("\\'", "'");
    }

    @Override
    public Object visitStringHash(HbsParser.StringHashContext ctx) {
        return ctx.getText().replace("\\\"", "\"");
    }

    @Override
    public Object visitStringParam(HbsParser.StringParamContext ctx) {
        return ctx.getText().replace("\\\"", "\"");
    }

    @Override
    public Object visitRefHash(HbsParser.RefHashContext ctx) {
        return ctx.getText();
    }

    @Override
    public Object visitRefPram(HbsParser.RefPramContext ctx) {
        return ctx.getText();
    }

    @Override
    public Object visitIntHash(HbsParser.IntHashContext ctx) {
        return Integer.parseInt(ctx.getText());
    }

    @Override
    public Object visitIntParam(HbsParser.IntParamContext ctx) {
        return Integer.parseInt(ctx.getText());
    }

    @Override
    public Template visitTemplate(HbsParser.TemplateContext ctx) {
        Template template = this.visitBody(ctx.body());
        if (!this.handlebars.infiniteLoops() && template instanceof BaseTemplate) {
            template = TemplateBuilder.infiniteLoop(this.source, (BaseTemplate)template);
        }
        this.destroy();
        return template;
    }

    private static Template infiniteLoop(final TemplateSource source, BaseTemplate template) {
        return new ForwardingTemplate(template){

            @Override
            protected void beforeApply(Context context) {
                LinkedList invocationStack = (LinkedList)context.data(Context.INVOCATION_STACK);
                invocationStack.addLast(source);
            }

            @Override
            protected void afterApply(Context context) {
                LinkedList invocationStack = (LinkedList)context.data(Context.INVOCATION_STACK);
                if (!invocationStack.isEmpty()) {
                    invocationStack.removeLast();
                }
            }
        };
    }

    @Override
    public Template visitPartial(HbsParser.PartialContext ctx) {
        this.hasTag(true);
        Token pathToken = ctx.PATH().getSymbol();
        String uri = pathToken.getText();
        if (uri.startsWith("[") && uri.endsWith("]")) {
            uri = uri.substring(1, uri.length() - 1);
        }
        if (uri.startsWith("/")) {
            String message = "found: '/', partial shouldn't start with '/'";
            this.reportError(null, pathToken.getLine(), pathToken.getCharPositionInLine(), message);
        }
        String indent = this.line.toString();
        if (this.hasTag()) {
            if (StringUtils.isEmpty((CharSequence)indent) || !StringUtils.isEmpty((CharSequence)indent.trim())) {
                indent = null;
            }
        } else {
            indent = null;
        }
        TerminalNode partialContext = ctx.QID();
        String startDelim = ctx.start.getText();
        BaseTemplate partial = new Partial(this.handlebars, uri, partialContext != null ? partialContext.getText() : "this").startDelimiter(startDelim.substring(0, startDelim.length() - 1)).endDelimiter(ctx.stop.getText()).indent(indent).filename(this.source.filename()).position(pathToken.getLine(), pathToken.getCharPositionInLine());
        return partial;
    }

    @Override
    public Template visitBody(HbsParser.BodyContext ctx) {
        List<HbsParser.StatementContext> stats = ctx.statement();
        if (stats.size() == 0) {
            return Template.EMPTY;
        }
        if (stats.size() == 1) {
            return this.visit((ParseTree)stats.get(0));
        }
        TemplateList list = new TemplateList();
        Template prev = null;
        for (HbsParser.StatementContext statement : stats) {
            Template candidate = this.visit((ParseTree)statement);
            if (candidate == null) continue;
            if (candidate instanceof Text) {
                if (!(prev instanceof Text)) {
                    list.add(candidate);
                    prev = candidate;
                    continue;
                }
                ((Text)prev).append(((Text)candidate).text());
                continue;
            }
            list.add(candidate);
            prev = candidate;
        }
        if (list.size() == 1) {
            return list.iterator().next();
        }
        return list;
    }

    @Override
    public Object visitComment(HbsParser.CommentContext ctx) {
        return Template.EMPTY;
    }

    @Override
    public Template visitStatement(HbsParser.StatementContext ctx) {
        return this.visit(ctx.getChild(0));
    }

    @Override
    public Template visitText(HbsParser.TextContext ctx) {
        String text = ctx.getText();
        this.line.append(text);
        return new Text(text);
    }

    @Override
    public Template visitSpaces(HbsParser.SpacesContext ctx) {
        Token space = ctx.SPACE().getSymbol();
        String text = space.getText();
        this.line.append(text);
        if (space.getChannel() == 1) {
            return null;
        }
        return new Text(text);
    }

    @Override
    public BaseTemplate visitNewline(HbsParser.NewlineContext ctx) {
        Token newline = ctx.NL().getSymbol();
        if (newline.getChannel() == 1) {
            return null;
        }
        this.line.setLength(0);
        return new Text(newline.getText());
    }

    private boolean hasTag() {
        if (this.handlebars.prettyPrint()) {
            return this.hasTag == null ? false : this.hasTag;
        }
        return false;
    }

    private void hasTag(boolean hasTag) {
        if (this.hasTag != Boolean.FALSE) {
            this.hasTag = hasTag;
        }
    }

    private void destroy() {
        this.handlebars = null;
        this.source = null;
        this.hasTag = null;
        this.line.delete(0, this.line.length());
        this.line = null;
    }

    protected void reportError(CommonToken offendingToken, String message) {
        this.reportError(offendingToken, offendingToken.getLine(), offendingToken.getCharPositionInLine(), message);
    }

    protected abstract void reportError(CommonToken var1, int var2, int var3, String var4);
}

