/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.internal.BaseTemplate;
import com.github.jknack.handlebars.internal.ParamType;
import com.github.jknack.handlebars.internal.Transformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

abstract class HelperResolver
extends BaseTemplate {
    protected final Handlebars handlebars;
    private List<Object> params = Collections.emptyList();
    private Map<String, Object> hash = Collections.emptyMap();
    private static final Object[] PARAMS = new Object[0];

    public HelperResolver(Handlebars handlebars) {
        this.handlebars = (Handlebars)Validate.notNull((Object)handlebars, (String)"The handlebars can't be null.", (Object[])new Object[0]);
    }

    protected Map<String, Object> hash(Context context) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.hash.entrySet()) {
            Object value = entry.getValue();
            value = ParamType.parse(context, value);
            result.put(entry.getKey(), value);
        }
        return result;
    }

    protected Object[] params(Context scope) {
        if (this.params.size() <= 1) {
            return PARAMS;
        }
        Object[] values = new Object[this.params.size() - 1];
        for (int i = 1; i < this.params.size(); ++i) {
            Object value = this.params.get(i);
            Object resolved = ParamType.parse(scope, value);
            values[i - 1] = resolved == null && this.handlebars.stringParams() ? value : resolved;
        }
        return values;
    }

    protected Object determineContext(Context context) {
        if (this.params.size() == 0) {
            return context.model();
        }
        Object value = this.params.get(0);
        value = ParamType.parse(context, value);
        return value;
    }

    protected Object transform(Object value) {
        return Transformer.transform(value);
    }

    protected Helper<Object> helper(String name) {
        Helper<Object> helper = this.handlebars.helper(name);
        if (helper == null && (this.params.size() > 0 || this.hash.size() > 0)) {
            Helper helperMissing = this.handlebars.helper("helperMissing");
            if (helperMissing == null) {
                throw new IllegalArgumentException("could not find helper: '" + name + "'");
            }
            helper = helperMissing;
        }
        return helper;
    }

    public HelperResolver hash(Map<String, Object> hash) {
        this.hash = hash == null || hash.size() == 0 ? Collections.emptyMap() : new LinkedHashMap<String, Object>(hash);
        return this;
    }

    public HelperResolver params(List<Object> params) {
        this.params = params == null || params.size() == 0 ? Collections.emptyList() : new ArrayList<Object>(params);
        return this;
    }

    protected String paramsToString() {
        if (this.params.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            String sep = " ";
            for (Object param : this.params) {
                buffer.append(param).append(sep);
            }
            buffer.setLength(buffer.length() - sep.length());
            return buffer.toString();
        }
        return "";
    }

    protected String hashToString() {
        if (this.hash.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            String sep = " ";
            for (Map.Entry<String, Object> hash : this.hash.entrySet()) {
                buffer.append(hash.getKey()).append("=").append(hash.getValue()).append(sep);
            }
            buffer.setLength(buffer.length() - sep.length());
            return buffer.toString();
        }
        return "";
    }
}

