/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;

public enum StringHelpers implements Helper<Object>
{
    capitalizeFirst{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            Validate.isTrue((boolean)(value instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{value});
            return StringUtils.capitalize((String)value.toString());
        }
    }
    ,
    center{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            Validate.isTrue((boolean)(value instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{value});
            Integer size = (Integer)options.hash("size");
            Validate.notNull((Object)size, (String)"found 'null', expected 'size'", (Object[])new Object[0]);
            String pad = (String)options.hash("pad", " ");
            return StringUtils.center((String)value.toString(), (int)size, (String)pad);
        }
    }
    ,
    cut{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            Validate.isTrue((boolean)(value instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{value});
            String strip = options.param(0, " ");
            return value.toString().replace(strip, "");
        }
    }
    ,
    defaultIfEmpty{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            if (Handlebars.Utils.isEmpty(value)) {
                return options.param(0, "");
            }
            return String.valueOf(value);
        }
    }
    ,
    join{

        @Override
        public CharSequence apply(Object context, Options options) throws IOException {
            int separatorIdx = options.params.length - 1;
            Object separator = options.param(separatorIdx, null);
            Validate.notNull(separator, (String)"found 'null', expected 'separator' at param[%s]", (Object[])new Object[]{separatorIdx});
            Validate.isTrue((boolean)(separator instanceof String), (String)"found '%s', expected 'separator' at param[%s]", (Object[])new Object[]{separator, separatorIdx});
            String prefix = (String)options.hash("prefix", "");
            String suffix = (String)options.hash("suffix", "");
            if (context instanceof Iterable) {
                return prefix + StringUtils.join((Iterable)((Iterable)context), (String)separator) + suffix;
            }
            if (context instanceof Iterator) {
                return prefix + StringUtils.join((Iterator)((Iterator)context), (String)separator) + suffix;
            }
            if (context.getClass().isArray()) {
                return prefix + StringUtils.join((Object[])((Object[])context), (String)separator) + suffix;
            }
            Object[] values = new Object[options.params.length];
            System.arraycopy(options.params, 0, values, 1, separatorIdx);
            values[0] = context;
            return prefix + StringUtils.join((Object[])values, (String)separator) + suffix;
        }
    }
    ,
    ljust{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            Validate.isTrue((boolean)(value instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{value});
            Integer size = (Integer)options.hash("size");
            Validate.notNull((Object)size, (String)"found 'null', expected 'size'", (Object[])new Object[0]);
            String pad = (String)options.hash("pad", " ");
            return StringUtils.rightPad((String)value.toString(), (int)size, (String)pad);
        }
    }
    ,
    rjust{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            Validate.isTrue((boolean)(value instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{value});
            Integer size = (Integer)options.hash("size");
            Validate.notNull((Object)size, (String)"found 'null', expected 'size'", (Object[])new Object[0]);
            String pad = (String)options.hash("pad", " ");
            return StringUtils.leftPad((String)value.toString(), (int)size, (String)pad);
        }
    }
    ,
    lower{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            Validate.isTrue((boolean)(value instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{value});
            return ((String)value).toLowerCase();
        }
    }
    ,
    upper{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            Validate.isTrue((boolean)(value instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{value});
            return ((String)value).toUpperCase();
        }
    }
    ,
    slugify{

        @Override
        public CharSequence apply(Object context, Options options) throws IOException {
            Validate.isTrue((boolean)(context instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{context});
            String value = StringUtils.strip((String)((String)context));
            StringBuilder buffer = new StringBuilder(value.length());
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (Character.isLetter(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
                if (!Character.isWhitespace(ch)) continue;
                buffer.append('-');
            }
            return buffer.toString();
        }
    }
    ,
    stringFormat{

        @Override
        public CharSequence apply(Object context, Options options) throws IOException {
            Validate.isTrue((boolean)(context instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{context});
            String format = (String)context;
            return String.format(format, options.params);
        }
    }
    ,
    stripTags{
        private final Pattern pattern = Pattern.compile("\\<[^>]*>", 32);

        @Override
        public CharSequence apply(Object context, Options options) throws IOException {
            Validate.isTrue((boolean)(context instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{context});
            Matcher matcher = this.pattern.matcher((String)context);
            return matcher.replaceAll("");
        }
    }
    ,
    capitalize{

        @Override
        public CharSequence apply(Object context, Options options) throws IOException {
            Validate.isTrue((boolean)(context instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{context});
            Boolean fully = (Boolean)options.hash("fully", false);
            String value = (String)context;
            return fully != false ? WordUtils.capitalizeFully((String)value) : WordUtils.capitalize((String)value);
        }
    }
    ,
    abbreviate{

        @Override
        public CharSequence apply(Object context, Options options) throws IOException {
            Validate.isTrue((boolean)(context instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{context});
            Integer width = options.param(0, null);
            Validate.notNull((Object)width, (String)"found 'null', expected 'width'", (Object[])new Object[0]);
            return StringUtils.abbreviate((String)((String)context), (int)width);
        }
    }
    ,
    wordWrap{

        @Override
        public CharSequence apply(Object context, Options options) throws IOException {
            Validate.isTrue((boolean)(context instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{context});
            Integer length = options.param(0, null);
            Validate.notNull((Object)length, (String)"found 'null', expected 'length'", (Object[])new Object[0]);
            return WordUtils.wrap((String)((String)context), (int)length);
        }
    }
    ,
    yesno{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            if (value == null) {
                return (CharSequence)options.hash("maybe", "maybe");
            }
            Validate.isTrue((boolean)(value instanceof Boolean), (String)"found '%s', expected 'boolean'", (Object[])new Object[]{value});
            if (Boolean.TRUE.equals(value)) {
                return (CharSequence)options.hash("yes", "yes");
            }
            return (CharSequence)options.hash("no", "no");
        }
    }
    ,
    dateFormat{
        private Map<String, Integer> styles = new HashMap<String, Integer>(){
            {
                this.put("full", 0);
                this.put("long", 1);
                this.put("medium", 2);
                this.put("short", 3);
            }
        };

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            Validate.isTrue((boolean)(value instanceof Date), (String)"found '%s', expected 'date'", (Object[])new Object[]{value});
            Date date = (Date)value;
            String pattern = options.param(0, "medium");
            String localeStr = options.param(1, Locale.getDefault().toString());
            Locale locale = LocaleUtils.toLocale((String)localeStr);
            Integer style = this.styles.get(pattern);
            DateFormat dateFormat = style == null ? new SimpleDateFormat(pattern.toString(), locale) : DateFormat.getDateInstance(style, locale);
            return dateFormat.format(date);
        }
    };


    public void registerHelper(Handlebars handlebars) {
        Validate.notNull((Object)handlebars, (String)"The handlebars is required.", (Object[])new Object[0]);
        handlebars.registerHelper(this.name(), this);
    }

    public static void register(Handlebars handlebars) {
        StringHelpers[] helpers;
        Validate.notNull((Object)handlebars, (String)"A handlebars object is required.", (Object[])new Object[0]);
        for (StringHelpers helper : helpers = StringHelpers.values()) {
            helper.registerHelper(handlebars);
        }
    }
}

