/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.HandlebarsError;
import com.github.jknack.handlebars.HandlebarsException;
import java.util.BitSet;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class HbsErrorReporter
implements ANTLRErrorListener {
    private String filename;

    public HbsErrorReporter(String filename) {
        this.filename = (String)Validate.notNull((Object)filename, (String)"A filename is required.", (Object[])new Object[0]);
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        int column = Math.max(1, charPositionInLine);
        CommonToken offendingToken = (CommonToken)offendingSymbol;
        String reason = offendingSymbol == null ? msg : offendingSymbol.toString();
        StringBuilder message = new StringBuilder();
        message.append(this.filename).append(":").append(line).append(":").append(column).append(": ");
        String stacktrace = "";
        if (offendingToken == null) {
            Object[] parts = StringUtils.split((String)msg, (String)"\n");
            message.append(parts[0]);
            stacktrace = "\n" + StringUtils.join((Object[])parts, (String)"\n", (int)1, (int)parts.length);
        } else {
            message.append("found: '").append(offendingToken.getText()).append("', ");
            message.append("expected: '").append(msg).append("'");
        }
        message.append("\n");
        int evidenceStat = message.length();
        String[] lines = this.lines(recognizer);
        this.underline(message, lines, line, column);
        String prevLine = lines[Math.max(0, line - 2)];
        String nextLine = lines[Math.min(lines.length - 1, line + 1)];
        String evidence = prevLine + "\n" + message.substring(evidenceStat) + "\n" + nextLine;
        message.append(stacktrace);
        HandlebarsError error = new HandlebarsError(this.filename, line, column, reason, evidence, message.toString());
        throw new HandlebarsException(error);
    }

    private void underline(StringBuilder message, String[] lines, int line, int charPositionInLine) {
        String errorLine = lines[line - 1];
        message.append(errorLine).append("\n");
        for (int i = 0; i < charPositionInLine; ++i) {
            message.append(" ");
        }
        message.append("^");
    }

    private String[] lines(Recognizer<?, ?> recognizer) {
        IntStream stream = recognizer.getInputStream();
        String input = stream instanceof CommonTokenStream ? ((CommonTokenStream)stream).getTokenSource().getInputStream().toString() : stream.toString();
        String[] lines = input.split("\n");
        return lines;
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet ambigAlts, ATNConfigSet configs) {
    }

    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, ATNConfigSet configs) {
    }

    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, ATNConfigSet configs) {
    }
}

