/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.springmvc;

import com.github.jknack.handlebars.TemplateLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.lang3.Validate;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringTemplateLoader
extends TemplateLoader {
    private ResourceLoader loader;

    public SpringTemplateLoader(ResourceLoader loader) {
        this.loader = (ResourceLoader)Validate.notNull((Object)loader, (String)"A resource loader is required.", (Object[])new Object[0]);
    }

    public SpringTemplateLoader(ApplicationContext applicationContext) {
        this((ResourceLoader)applicationContext);
    }

    public String resolve(String uri) {
        String protocol = null;
        if (uri.startsWith("classpath:")) {
            protocol = "classpath:";
        } else if (uri.startsWith("file:")) {
            protocol = "file:";
        }
        if (protocol == null) {
            return super.resolve(uri);
        }
        return protocol + super.resolve(uri.substring(protocol.length()));
    }

    protected Reader read(String location) throws IOException {
        Resource resource = this.loader.getResource(location);
        if (resource.exists()) {
            return new InputStreamReader(resource.getInputStream());
        }
        return null;
    }
}

