/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.springmvc;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.TemplateLoader;
import com.github.jknack.handlebars.springmvc.HandlebarsView;
import com.github.jknack.handlebars.springmvc.SpringTemplateLoader;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class HandlebarsViewResolver
extends AbstractTemplateViewResolver
implements InitializingBean {
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    private Handlebars handlebars;

    public HandlebarsViewResolver(Handlebars handlebars) {
        this();
        this.handlebars = (Handlebars)Validate.notNull((Object)handlebars, (String)"A handlebars object is required.", (Object[])new Object[0]);
    }

    public HandlebarsViewResolver() {
        this.setViewClass(HandlebarsView.class);
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setPrefix("/");
        this.setSuffix(".hbs");
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        return this.configure((HandlebarsView)super.buildView(viewName));
    }

    protected AbstractUrlBasedView configure(HandlebarsView view) throws IOException {
        String url = view.getUrl();
        url = url.substring(this.getPrefix().length(), url.length() - this.getSuffix().length());
        view.setTemplate(this.handlebars.compile(URI.create(url)));
        return view;
    }

    protected Class<?> requiredViewClass() {
        return HandlebarsView.class;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.handlebars == null) {
            this.handlebars = new Handlebars((TemplateLoader)new SpringTemplateLoader(this.getApplicationContext()));
        }
        TemplateLoader templateLoader = this.handlebars.getTemplateLoader();
        templateLoader.setPrefix(this.getPrefix());
        templateLoader.setSuffix(this.getSuffix());
    }
}

