/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.maven;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class HandlebarsPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doExecute();
        }
        catch (MojoExecutionException | MojoFailureException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        catch (Exception ex) {
            throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected abstract void doExecute() throws Exception;

    protected URL[] projectClasspath() throws Exception {
        List classpathElements = this.project.getRuntimeClasspathElements();
        URL[] classpath = new URL[classpathElements.size()];
        for (int i = 0; i < classpath.length; ++i) {
            classpath[i] = new File((String)classpathElements.get(i)).toURI().toURL();
        }
        return classpath;
    }
}

