/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class Jackson2Helper
implements Helper<Object> {
    public static final Helper<Object> INSTANCE = new Jackson2Helper();
    private final ObjectMapper mapper;
    private final Map<String, Class<?>> alias = new HashMap();

    public Jackson2Helper(ObjectMapper objectMapper) {
        this.mapper = (ObjectMapper)Validate.notNull((Object)objectMapper, (String)"The object mapper is required.", (Object[])new Object[0]);
    }

    private Jackson2Helper() {
        this(new ObjectMapper());
    }

    public CharSequence apply(Object context, Options options) throws IOException {
        ObjectWriter writer;
        if (context == null) {
            return "";
        }
        String viewName = (String)options.hash("view", (Object)"");
        if (viewName.length() > 0) {
            try {
                Class<?> viewClass = this.alias.get(viewName);
                if (viewClass == null) {
                    viewClass = this.getClass().getClassLoader().loadClass(viewName);
                }
                writer = this.mapper.writerWithView(viewClass);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(viewName, ex);
            }
        } else {
            writer = this.mapper.writer();
        }
        return new Handlebars.SafeString((CharSequence)writer.writeValueAsString(context));
    }

    public Jackson2Helper viewAlias(String alias, Class<?> viewClass) {
        this.alias.put((String)Validate.notEmpty((CharSequence)alias, (String)"A view alias is required.", (Object[])new Object[0]), (Class<?>)Validate.notNull(viewClass, (String)"A view class is required.", (Object[])new Object[0]));
        return this;
    }
}

