/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class GuavaCachedTemplateLoader
implements TemplateLoader {
    private final TemplateLoader delegate;
    private final Cache<String, TemplateSource> cache;

    public GuavaCachedTemplateLoader(TemplateLoader delegate, Cache<String, TemplateSource> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    public static GuavaCachedTemplateLoader cacheWithExpiration(TemplateLoader delegate, long duration, TimeUnit unit) {
        Cache cache = CacheBuilder.newBuilder().expireAfterAccess(duration, unit).build();
        return new GuavaCachedTemplateLoader(delegate, (Cache<String, TemplateSource>)cache);
    }

    public TemplateSource sourceAt(final String location) throws IOException {
        try {
            return (TemplateSource)this.cache.get((Object)location, (Callable)new Callable<TemplateSource>(){

                @Override
                public TemplateSource call() throws Exception {
                    return GuavaCachedTemplateLoader.this.delegate.sourceAt(location);
                }
            });
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public String resolve(String location) {
        return this.delegate.resolve(location);
    }

    public String getPrefix() {
        return this.delegate.getPrefix();
    }

    public String getSuffix() {
        return this.delegate.getSuffix();
    }

    public void setPrefix(String prefix) {
        this.delegate.setPrefix(prefix);
    }

    public void setSuffix(String suffix) {
        this.delegate.setSuffix(suffix);
    }
}

