/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.core;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import com.luojilab.component.componentlib.log.ILogger;
import org.github.jimu.msg.EventManager;
import org.github.jimu.msg.bean.RemoteEventBean;
import org.github.jimu.msg.bean.State;
import org.github.jimu.msg.core.Secy;

public class CrossSubscriberHandler
extends Handler {
    CrossSubscriberHandler() {
    }

    public void handleMessage(Message msg) {
        if (msg == null) {
            ILogger.logger.error("[DD-Compo]", "subscriber handle get a null message");
            return;
        }
        switch (msg.what) {
            case 2: {
                this.postRemoteEventInCurrentProcess(msg);
                break;
            }
        }
    }

    private void postRemoteEventInCurrentProcess(@NonNull Message message) {
        if (message.getData() == null) {
            ILogger.logger.error("[DD-Compo]", "subscriber handle get a message without bundle data");
            return;
        }
        Bundle data = message.getData();
        data.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        if (!data.containsKey("bundle_event_parcelable") || !data.containsKey("bundle_str_event_clz")) {
            ILogger.logger.error("[DD-Compo]", "subscriber handle get a message missing params in bundle");
            return;
        }
        RemoteEventBean event = (RemoteEventBean)data.getParcelable("bundle_event_parcelable");
        String eventClzPath = data.getString("bundle_str_event_clz");
        try {
            Class<?> clz = Class.forName(eventClzPath);
            EventManager.getInstance().fastHandleLocalProcessEvent(this, event, clz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            ILogger.logger.error("[DD-Compo]", "wtf:" + e.getMessage());
        }
    }

    public void onFastHandleLocalProcessEvent(Secy secy, State state, RemoteEventBean event, Class clz) {
        secy.postOneOnLocalProcess(event, state, clz);
    }
}

