/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import info.monitorenter.util.Entry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private final ResourceBundle m_bundle = ResourceBundle.getBundle("messages");

    public static Map.Entry<String, String> cutDirectoryInformation(String path) {
        StringBuffer dir = new StringBuffer();
        String file = "";
        String fileseparator = System.getProperty("file.separator");
        StringTokenizer tokenizer = new StringTokenizer(path, fileseparator);
        int size = tokenizer.countTokens();
        switch (size) {
            case 0: {
                dir.append(new File(".").getAbsolutePath());
                break;
            }
            case 1: {
                File test = new File(tokenizer.nextToken());
                if (new File(path).isDirectory()) {
                    dir.append(test.getAbsolutePath());
                    break;
                }
                dir.append(new File(".").getAbsolutePath());
                file = path;
                break;
            }
            default: {
                while (tokenizer.hasMoreElements()) {
                    String token = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        dir.append(token);
                        dir.append(fileseparator);
                        continue;
                    }
                    if (new File(path).isFile()) {
                        file = token;
                        continue;
                    }
                    dir.append(token);
                }
                break block0;
            }
        }
        return new Entry<String, String>(dir.toString(), file);
    }

    public static Map.Entry<String, String> cutExtension(String filename) {
        String prefix;
        String suffix = null;
        StringTokenizer tokenizer = new StringTokenizer(filename, ".");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount > 1) {
            StringBuffer prefCollect = new StringBuffer();
            while (tokenCount > 1) {
                prefCollect.append(tokenizer.nextToken());
                if (--tokenCount <= 1) continue;
                prefCollect.append(".");
            }
            prefix = prefCollect.toString();
            suffix = tokenizer.nextToken();
        } else {
            prefix = filename;
            suffix = "";
        }
        return new Entry<String, String>(prefix, suffix);
    }

    public static boolean isAllASCII(InputStream in) throws IOException {
        boolean ret = true;
        int read = -1;
        do {
            if ((read = in.read()) <= 127) continue;
            ret = false;
            break;
        } while (read != -1);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readRAM(File f) throws IOException {
        int total = (int)f.length();
        byte[] ret = new byte[total];
        FileInputStream in = new FileInputStream(f);
        try {
            int offset = 0;
            int read = 0;
            do {
                if ((read = ((InputStream)in).read(ret, offset, total - read)) <= 0) continue;
                offset += read;
            } while (read != -1 && offset != total);
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private FileUtil() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileUtil other = (FileUtil)obj;
        return !(this.m_bundle == null ? other.m_bundle != null : !this.m_bundle.equals(other.m_bundle));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_bundle == null ? 0 : this.m_bundle.hashCode());
        return result;
    }
}

