/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TimePicker;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jiangdg.common.R;
import com.jiangdg.widget.DialogPreferenceV7;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimePickerPreferenceV7
extends DialogPreferenceV7 {
    private final Calendar calendar;
    private final long mDefaultValue;
    private TimePicker picker = null;

    public TimePickerPreferenceV7(@NonNull Context context) {
        this(context, null);
    }

    public TimePickerPreferenceV7(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0x1010091);
    }

    public TimePickerPreferenceV7(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyle, 0);
        this.mDefaultValue = (long)a.getFloat(R.styleable.TimePicker_TimePickerDefaultValue, -1.0f);
        a.recycle();
        this.setPositiveButtonText(17039370);
        this.setNegativeButtonText(0x1040000);
        this.calendar = new GregorianCalendar();
    }

    @Override
    protected View onCreateDialogView() {
        this.picker = new TimePicker(this.getContext());
        this.picker.setIs24HourView(Boolean.valueOf(true));
        return this.picker;
    }

    @Override
    protected void onBindDialogView(@NonNull View view) {
        super.onBindDialogView(view);
        this.picker.setCurrentHour(Integer.valueOf(this.calendar.get(11)));
        this.picker.setCurrentMinute(Integer.valueOf(this.calendar.get(12)));
    }

    @Override
    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (positiveResult) {
            this.calendar.set(11, this.picker.getCurrentHour());
            this.calendar.set(12, this.picker.getCurrentMinute());
            this.setSummary(this.getSummary());
            if (this.callChangeListener(this.calendar.getTimeInMillis())) {
                this.persistLong(this.calendar.getTimeInMillis());
                this.notifyChanged();
            }
        }
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    protected void onSetInitialValue(@Nullable Object defaultValue) {
        long v;
        long l = v = this.mDefaultValue > 0L ? this.mDefaultValue : System.currentTimeMillis();
        if (defaultValue != null) {
            this.calendar.setTimeInMillis(Long.parseLong((String)defaultValue));
        } else {
            this.calendar.setTimeInMillis(v);
        }
        this.setSummary(this.getSummary());
    }

    public CharSequence getSummary() {
        if (this.calendar == null) {
            return null;
        }
        return DateFormat.getTimeFormat((Context)this.getContext()).format(new Date(this.calendar.getTimeInMillis()));
    }
}

