/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.widget;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.jiangdg.common.R;
import com.jiangdg.widget.CustomRecycleViewListener;
import com.jiangdg.widget.Dividable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class CustomRecycleViewAdapter<T>
extends RecyclerView.Adapter<ViewHolder<T>> {
    private static final boolean DEBUG = false;
    private static final String TAG = CustomRecycleViewAdapter.class.getSimpleName();
    @LayoutRes
    private final int mItemViewId;
    @NonNull
    private final List<T> mItems;
    private LayoutInflater mLayoutInflater;
    private RecyclerView mRecycleView;
    private CustomRecycleViewListener<T> mCustomRecycleViewListener;
    private Handler mUIHandler = new Handler(Looper.getMainLooper());
    protected final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(final View v) {
            if (CustomRecycleViewAdapter.this.mRecycleView != null) {
                if (v instanceof Checkable) {
                    ((Checkable)v).setChecked(true);
                    CustomRecycleViewAdapter.this.mUIHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ((Checkable)v).setChecked(false);
                        }
                    }, 100L);
                }
                if (CustomRecycleViewAdapter.this.mCustomRecycleViewListener != null) {
                    Integer pos = (Integer)v.getTag(R.id.position);
                    if (pos != null) {
                        try {
                            Object item = CustomRecycleViewAdapter.this.getItem(pos);
                            CustomRecycleViewAdapter.this.mCustomRecycleViewListener.onItemClick(CustomRecycleViewAdapter.this, v, pos, item);
                            return;
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (Throwable)e);
                        }
                    }
                    try {
                        int position = CustomRecycleViewAdapter.this.mRecycleView.getChildAdapterPosition(v);
                        Object item = CustomRecycleViewAdapter.this.getItem(position);
                        CustomRecycleViewAdapter.this.mCustomRecycleViewListener.onItemClick(CustomRecycleViewAdapter.this, v, position, item);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
            }
        }
    };
    protected final View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            if (CustomRecycleViewAdapter.this.mRecycleView != null) {
                try {
                    if (CustomRecycleViewAdapter.this.mCustomRecycleViewListener != null) {
                        int position = CustomRecycleViewAdapter.this.mRecycleView.getChildAdapterPosition(v);
                        Object item = CustomRecycleViewAdapter.this.getItem(position);
                        return CustomRecycleViewAdapter.this.mCustomRecycleViewListener.onItemLongClick(CustomRecycleViewAdapter.this, v, position, item);
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
            return false;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomRecycleViewAdapter(@LayoutRes int layout_id, @NonNull List<T> devices) {
        this.mItemViewId = layout_id;
        List<T> list = this.mItems = devices;
        synchronized (list) {
            this.registerDataSetObserver(this.mItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        List<T> list = this.mItems;
        synchronized (list) {
            this.unregisterDataSetObserver(this.mItems);
        }
        super.finalize();
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecycleView = recyclerView;
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mRecycleView = null;
        super.onDetachedFromRecyclerView(recyclerView);
    }

    @NonNull
    public ViewHolder<T> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = this.getLayoutInflater(parent.getContext());
        View view = this.onCreateItemView(inflater, parent, viewType);
        view.setOnClickListener(this.mOnClickListener);
        view.setOnLongClickListener(this.mOnLongClickListener);
        return this.onCreateViewHolder(view);
    }

    protected View onCreateItemView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        return inflater.inflate(this.mItemViewId, parent, false);
    }

    protected ViewHolder<T> onCreateViewHolder(View item) {
        return new ViewHolder(item);
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public T getItem(int position) {
        return position >= 0 && position < this.mItems.size() ? (T)this.mItems.get(position) : null;
    }

    public void setOnItemClickListener(CustomRecycleViewListener<T> listener) {
        this.mCustomRecycleViewListener = listener;
    }

    @Nullable
    public RecyclerView getParent() {
        return this.mRecycleView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<T> list = this.mItems;
        synchronized (list) {
            this.unregisterDataSetObserver(this.mItems);
            this.mItems.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<? extends T> collection) {
        List<T> list = this.mItems;
        synchronized (list) {
            this.unregisterDataSetObserver(this.mItems);
            this.mItems.clear();
            this.mItems.addAll(collection);
            this.registerDataSetObserver(this.mItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator<? super T> comparator) {
        List<T> list = this.mItems;
        synchronized (list) {
            Collections.sort(this.mItems, comparator);
        }
    }

    protected LayoutInflater getLayoutInflater(Context context) {
        if (this.mLayoutInflater == null) {
            this.mLayoutInflater = LayoutInflater.from((Context)context);
        }
        return this.mLayoutInflater;
    }

    protected abstract void registerDataSetObserver(List<T> var1);

    protected abstract void unregisterDataSetObserver(List<T> var1);

    public static class ViewHolder<T>
    extends RecyclerView.ViewHolder {
        public final View mView;
        public T mItem;

        public ViewHolder(View view) {
            super(view);
            this.mView = view;
        }

        @NonNull
        public String toString() {
            return super.toString() + " '" + this.mItem + "'";
        }

        public void setEnable(boolean enable) {
            this.mView.setEnabled(enable);
        }

        public void hasDivider(boolean hasDivider) {
            if (this.mView instanceof Dividable) {
                ((Dividable)this.mView).hasDivider(hasDivider);
            } else {
                this.mView.setTag(R.id.has_divider, (Object)hasDivider);
            }
        }

        public boolean hasDivider() {
            if (this.mView instanceof Dividable) {
                return ((Dividable)this.mView).hasDivider();
            }
            Boolean b = (Boolean)this.mView.getTag(R.id.has_divider);
            return b != null && b != false;
        }
    }
}

