/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.utils;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;

public final class UIThreadHelper {
    private static final String TAG = UIThreadHelper.class.getSimpleName();
    private static final Handler sUIHandler = new Handler(Looper.getMainLooper());
    private static final Thread sUiThread = sUIHandler.getLooper().getThread();

    public static final void runOnUiThread(@NonNull Runnable task) {
        if (Thread.currentThread() != sUiThread) {
            sUIHandler.post(task);
        } else {
            try {
                task.run();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public static final void runOnUiThread(@NonNull Runnable task, long duration) {
        if (duration > 0L || Thread.currentThread() != sUiThread) {
            sUIHandler.postDelayed(task, duration);
        } else {
            try {
                task.run();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public static final void removeFromUiThread(@NonNull Runnable task) {
        sUIHandler.removeCallbacks(task);
    }
}

