/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.utils;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SysFs {
    private static final boolean DEBUG = false;
    private static final String TAG = SysFs.class.getSimpleName();
    private static final Map<String, WeakReference<ReentrantReadWriteLock>> sSysFs = new HashMap<String, WeakReference<ReentrantReadWriteLock>>();
    private final String mPath;
    private final String mName;
    protected final ReentrantReadWriteLock mLock;
    private final Lock mReadLock;
    private final Lock mWriteLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SysFs(@NonNull String path) throws IOException {
        File f = new File(path);
        if (!f.exists() || !f.canRead()) {
            throw new IOException(path + " does not exist or can't read.");
        }
        this.mPath = path;
        this.mName = f.getName();
        ReentrantReadWriteLock lock = null;
        Map<String, WeakReference<ReentrantReadWriteLock>> map = sSysFs;
        synchronized (map) {
            if (sSysFs.containsKey(path)) {
                WeakReference<ReentrantReadWriteLock> weakLock = sSysFs.get(path);
                ReentrantReadWriteLock reentrantReadWriteLock = lock = weakLock != null ? (ReentrantReadWriteLock)weakLock.get() : null;
            }
            if (lock == null) {
                lock = new ReentrantReadWriteLock();
                sSysFs.put(path, new WeakReference<ReentrantReadWriteLock>(lock));
            }
        }
        this.mLock = lock;
        this.mReadLock = lock.readLock();
        this.mWriteLock = lock.writeLock();
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
    }

    public String getPath() {
        return this.mPath;
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString(@Nullable String name) throws IOException {
        String result;
        this.mReadLock.lock();
        try (FileReader in = new FileReader(this.getPath(name));){
            result = new BufferedReader(in).readLine();
        }
        finally {
            this.mReadLock.unlock();
        }
        return result;
    }

    public String readString() throws IOException {
        return this.readString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(@Nullable String name) throws IOException {
        byte[] result;
        this.mReadLock.lock();
        try {
            byte[] buf = new byte[512];
            MyByteArrayOutputStream out = new MyByteArrayOutputStream(1024);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.getPath(name)));){
                int available = ((InputStream)in).available();
                while (available > 0) {
                    int bytes = ((InputStream)in).read(buf);
                    if (bytes > 0) {
                        out.write(buf, 0, bytes);
                    }
                    available = ((InputStream)in).available();
                }
                result = out.toByteArray();
            }
        }
        finally {
            this.mReadLock.unlock();
        }
        return result;
    }

    public byte[] readBytes() throws IOException {
        return this.readBytes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte(@Nullable String name) throws IOException {
        this.mReadLock.lock();
        try {
            byte by;
            DataInputStream in = new DataInputStream(new FileInputStream(this.getPath(name)));
            try {
                by = in.readByte();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return by;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public byte readByte() throws IOException {
        return this.readByte(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort(@Nullable String name) throws IOException {
        this.mReadLock.lock();
        try {
            short s;
            DataInputStream in = new DataInputStream(new FileInputStream(this.getPath(name)));
            try {
                s = in.readShort();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return s;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public short readShort() throws IOException {
        return this.readShort(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt(@Nullable String name) throws IOException {
        this.mReadLock.lock();
        try {
            int n;
            DataInputStream in = new DataInputStream(new FileInputStream(this.getPath(name)));
            try {
                n = in.readInt();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return n;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public int readInt() throws IOException {
        return this.readInt(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong(@Nullable String name) throws IOException {
        this.mReadLock.lock();
        try {
            long l;
            DataInputStream in = new DataInputStream(new FileInputStream(this.getPath(name)));
            try {
                l = in.readLong();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return l;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public long readLong() throws IOException {
        return this.readLong(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float readFloat(@Nullable String name) throws IOException {
        this.mReadLock.lock();
        try {
            float f;
            DataInputStream in = new DataInputStream(new FileInputStream(this.getPath(name)));
            try {
                f = in.readFloat();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return f;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public float readFloat() throws IOException {
        return this.readFloat(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readDouble(@Nullable String name) throws IOException {
        this.mReadLock.lock();
        try {
            double d;
            DataInputStream in = new DataInputStream(new FileInputStream(this.getPath(name)));
            try {
                d = in.readDouble();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return d;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public double readDouble() throws IOException {
        return this.readDouble(null);
    }

    public void write(@Nullable String name, @NonNull byte[] value) throws IOException {
        this.write(name, value, 0, value.length);
    }

    public void write(@NonNull byte[] value) throws IOException {
        this.write(null, value, 0, value.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nullable String name, @NonNull byte[] value, int offset, int length) throws IOException {
        this.mWriteLock.lock();
        try (FileOutputStream out = new FileOutputStream(this.getPath(name));){
            ((OutputStream)out).write(value, offset, length);
            out.flush();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void write(@NonNull byte[] value, int offset, int length) throws IOException {
        this.write(null, value, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nullable String name, @NonNull String value) throws IOException {
        this.mWriteLock.lock();
        try (FileWriter out = new FileWriter(this.getPath(name));){
            out.write(value);
            out.flush();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void write(@NonNull String value) throws IOException {
        this.write(null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nullable String name, boolean value) throws IOException {
        this.mWriteLock.lock();
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.getPath(name)));){
            out.writeBoolean(value);
            out.flush();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void write(boolean value) throws IOException {
        this.write(null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nullable String name, byte value) throws IOException {
        this.mWriteLock.lock();
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.getPath(name)));){
            out.writeByte(value);
            out.flush();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void write(byte value) throws IOException {
        this.write((String)null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nullable String name, short value) throws IOException {
        this.mWriteLock.lock();
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.getPath(name)));){
            out.writeShort(value);
            out.flush();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void write(short value) throws IOException {
        this.write((String)null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nullable String name, int value) throws IOException {
        this.mWriteLock.lock();
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.getPath(name)));){
            out.writeInt(value);
            out.flush();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void write(int value) throws IOException {
        this.write((String)null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nullable String name, float value) throws IOException {
        this.mWriteLock.lock();
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.getPath(name)));){
            out.writeFloat(value);
            out.flush();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void write(float value) throws IOException {
        this.write((String)null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nullable String name, double value) throws IOException {
        this.mWriteLock.lock();
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.getPath(name)));){
            out.writeDouble(value);
            out.flush();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public void write(double value) throws IOException {
        this.write(null, value);
    }

    public String toString() {
        try {
            return String.format(Locale.US, "%s=%s", this.mPath, this.readString());
        }
        catch (IOException e) {
            return String.format(Locale.US, "%s=null", this.mPath);
        }
    }

    private File getPath(@Nullable String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return new File(this.mPath);
        }
        File f = new File(this.mPath);
        return new File(f, name);
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        public MyByteArrayOutputStream() {
        }

        public MyByteArrayOutputStream(int size) {
            super(size);
        }

        public ByteBuffer getByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.size());
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

