/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.utils;

import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.jiangdg.utils.ObjectHelper;
import java.util.Map;

public class PrefHelper {
    public static short get(@Nullable SharedPreferences pref, String key, short defaultValue) {
        short result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = (short)pref.getInt(key, (int)defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asShort(PrefHelper.getObject(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public static int get(@Nullable SharedPreferences pref, String key, int defaultValue) {
        int result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = pref.getInt(key, defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asInt(PrefHelper.getObject(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public static long get(@Nullable SharedPreferences pref, String key, long defaultValue) {
        long result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = pref.getLong(key, defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asLong(PrefHelper.getObject(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public static float get(@Nullable SharedPreferences pref, String key, float defaultValue) {
        float result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = pref.getFloat(key, defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asFloat(PrefHelper.getObject(pref, key, Float.valueOf(defaultValue)), defaultValue);
            }
        }
        return result;
    }

    public static double get(@Nullable SharedPreferences pref, String key, double defaultValue) {
        double result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = Double.parseDouble(pref.getString(key, Double.toString(defaultValue)));
            }
            catch (Exception e) {
                result = ObjectHelper.asDouble(PrefHelper.getObject(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public static boolean get(@Nullable SharedPreferences pref, String key, boolean defaultValue) {
        boolean result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = pref.getBoolean(key, defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asBoolean(PrefHelper.get(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public static final Object getObject(@Nullable SharedPreferences pref, String key) {
        return PrefHelper.getObject(pref, key, null);
    }

    public static final Object getObject(@Nullable SharedPreferences pref, String key, Object defaultValue) {
        Object result = defaultValue;
        if (pref != null && pref.contains(key)) {
            Map all = pref.getAll();
            result = all.get(key);
        }
        return result;
    }
}

