/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.utils;

import android.util.Log;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class MessageTask
implements Runnable {
    private static final String TAG = MessageTask.class.getSimpleName();
    protected static final int REQUEST_TASK_NON = 0;
    protected static final int REQUEST_TASK_RUN = -1;
    protected static final int REQUEST_TASK_RUN_AND_WAIT = -2;
    protected static final int REQUEST_TASK_START = -8;
    protected static final int REQUEST_TASK_QUIT = -9;
    private final Object mSync = new Object();
    private final int mMaxRequest;
    private final LinkedBlockingQueue<Request> mRequestPool;
    private final LinkedBlockingDeque<Request> mRequestQueue;
    private volatile boolean mIsRunning;
    private volatile boolean mFinished;
    private Thread mWorkerThread;

    public MessageTask() {
        this.mMaxRequest = -1;
        this.mRequestPool = new LinkedBlockingQueue();
        this.mRequestQueue = new LinkedBlockingDeque();
    }

    public MessageTask(int init_num) {
        this.mMaxRequest = -1;
        this.mRequestPool = new LinkedBlockingQueue();
        this.mRequestQueue = new LinkedBlockingDeque();
        for (int i = 0; i < init_num && this.mRequestPool.offer(new Request()); ++i) {
        }
    }

    public MessageTask(int max_request, int init_num) {
        this.mMaxRequest = max_request;
        this.mRequestPool = new LinkedBlockingQueue(max_request);
        this.mRequestQueue = new LinkedBlockingDeque(max_request);
        for (int i = 0; i < init_num && this.mRequestPool.offer(new Request()); ++i) {
        }
    }

    protected void init(int arg1, int arg2, Object obj) {
        this.mFinished = false;
        this.mRequestQueue.offer(this.obtain(-8, arg1, arg2, obj));
    }

    protected abstract void onInit(int var1, int var2, Object var3);

    protected abstract void onStart();

    protected void onBeforeStop() {
    }

    protected abstract void onStop();

    protected abstract void onRelease();

    protected boolean onError(Exception e) {
        return true;
    }

    protected abstract Object processRequest(int var1, int var2, int var3, Object var4) throws TaskBreak;

    protected Request takeRequest() throws InterruptedException {
        return this.mRequestQueue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitReady() {
        Object object = this.mSync;
        synchronized (object) {
            while (!this.mIsRunning && !this.mFinished) {
                try {
                    this.mSync.wait(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            return this.mIsRunning;
        }
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public boolean isFinished() {
        return this.mFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Request request;
        block39: {
            request = null;
            this.mIsRunning = true;
            try {
                request = this.mRequestQueue.take();
            }
            catch (InterruptedException e) {
                this.mIsRunning = false;
                this.mFinished = true;
            }
            Object e = this.mSync;
            synchronized (e) {
                if (this.mIsRunning) {
                    this.mWorkerThread = Thread.currentThread();
                    try {
                        this.onInit(request.arg1, request.arg2, request.obj);
                    }
                    catch (Exception e2) {
                        Log.w((String)TAG, (Throwable)e2);
                        this.mIsRunning = false;
                        this.mFinished = true;
                    }
                }
                this.mSync.notifyAll();
            }
            if (this.mIsRunning) {
                try {
                    this.onStart();
                }
                catch (Exception e3) {
                    if (!this.callOnError(e3)) break block39;
                    this.mIsRunning = false;
                    this.mFinished = true;
                }
            }
        }
        block35: while (this.mIsRunning) {
            try {
                request = this.takeRequest();
                switch (request.request) {
                    case 0: {
                        break;
                    }
                    case -9: {
                        break block35;
                    }
                    case -1: {
                        if (!(request.obj instanceof Runnable)) break;
                        try {
                            ((Runnable)request.obj).run();
                            break;
                        }
                        catch (Exception e) {
                            if (!this.callOnError(e)) break;
                            break block35;
                        }
                    }
                    case -2: {
                        try {
                            request.setResult(this.processRequest(request.request_for_result, request.arg1, request.arg2, request.obj));
                            break;
                        }
                        catch (TaskBreak e) {
                            request.setResult(null);
                            break block35;
                        }
                        catch (Exception e) {
                            request.setResult(null);
                            if (!this.callOnError(e)) break;
                            break block35;
                        }
                    }
                    default: {
                        try {
                            this.processRequest(request.request, request.arg1, request.arg2, request.obj);
                            break;
                        }
                        catch (TaskBreak e) {
                            break block35;
                        }
                        catch (Exception e) {
                            if (this.callOnError(e)) break block35;
                        }
                    }
                }
                request.request_for_result = 0;
                request.request = 0;
                this.mRequestPool.offer(request);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        boolean interrupted = Thread.interrupted();
        Object e2 = this.mSync;
        synchronized (e2) {
            this.mWorkerThread = null;
            this.mIsRunning = false;
            this.mFinished = true;
        }
        if (!interrupted) {
            try {
                this.onBeforeStop();
                this.onStop();
            }
            catch (Exception e) {
                this.callOnError(e);
            }
        }
        try {
            this.onRelease();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.mSync;
        synchronized (object) {
            this.mSync.notifyAll();
        }
    }

    protected boolean callOnError(Exception e) {
        try {
            return this.onError(e);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected Request obtain(int request, int arg1, int arg2, Object obj) {
        Request req = this.mRequestPool.poll();
        if (req != null) {
            req.request = request;
            req.arg1 = arg1;
            req.arg2 = arg2;
            req.obj = obj;
        } else {
            req = new Request(request, arg1, arg2, obj);
        }
        return req;
    }

    public boolean offer(int request, int arg1, int arg2, Object obj) {
        return !this.mFinished && this.mRequestQueue.offer(this.obtain(request, arg1, arg2, obj));
    }

    public boolean offer(int request, int arg1, Object obj) {
        return !this.mFinished && this.mRequestQueue.offer(this.obtain(request, arg1, 0, obj));
    }

    public boolean offer(int request, int arg1, int arg2) {
        return !this.mFinished && this.mIsRunning && this.mRequestQueue.offer(this.obtain(request, arg1, arg2, null));
    }

    public boolean offer(int request, int arg1) {
        return !this.mFinished && this.mIsRunning && this.mRequestQueue.offer(this.obtain(request, arg1, 0, null));
    }

    public boolean offer(int request) {
        return !this.mFinished && this.mIsRunning && this.mRequestQueue.offer(this.obtain(request, 0, 0, null));
    }

    public boolean offer(int request, Object obj) {
        return !this.mFinished && this.mIsRunning && this.mRequestQueue.offer(this.obtain(request, 0, 0, obj));
    }

    public boolean offerFirst(int request, int arg1, int arg2, Object obj) {
        return !this.mFinished && this.mIsRunning && this.mRequestQueue.offerFirst(this.obtain(request, arg1, arg2, obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object offerAndWait(int request, int arg1, int arg2, Object obj) {
        if (!this.mFinished && request > 0) {
            Request req;
            Request request2 = req = this.obtain(-2, arg1, arg2, obj);
            synchronized (request2) {
                req.request_for_result = request;
                req.result = null;
                this.mRequestQueue.offer(req);
                while (this.mIsRunning && req.request_for_result != 0) {
                    try {
                        req.wait(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            return req.result;
        }
        return null;
    }

    public boolean queueEvent(Runnable task) {
        return !this.mFinished && task != null && this.offer(-1, task);
    }

    public void removeRequest(Request request) {
        for (Request req : this.mRequestQueue) {
            if (!this.mIsRunning || this.mFinished) break;
            if (!req.equals(request)) continue;
            this.mRequestQueue.remove(req);
            this.mRequestPool.offer(req);
        }
    }

    public void removeRequest(int request) {
        for (Request req : this.mRequestQueue) {
            if (!this.mIsRunning || this.mFinished) break;
            if (req.request != request) continue;
            this.mRequestQueue.remove(req);
            this.mRequestPool.offer(req);
        }
    }

    public void release() {
        this.release(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean interrupt) {
        boolean b = this.mIsRunning;
        this.mIsRunning = false;
        if (!this.mFinished) {
            this.mRequestQueue.clear();
            this.mRequestQueue.offerFirst(this.obtain(-9, 0, 0, null));
            Object object = this.mSync;
            synchronized (object) {
                if (b) {
                    long id2;
                    long current = Thread.currentThread().getId();
                    long l = id2 = this.mWorkerThread != null ? this.mWorkerThread.getId() : current;
                    if (id2 != current) {
                        if (interrupt && this.mWorkerThread != null) {
                            this.mWorkerThread.interrupt();
                        }
                        while (!this.mFinished) {
                            try {
                                this.mSync.wait(300L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
            }
        }
    }

    public void releaseSelf() {
        this.mIsRunning = false;
        if (!this.mFinished) {
            this.mRequestQueue.clear();
            this.mRequestQueue.offerFirst(this.obtain(-9, 0, 0, null));
        }
    }

    public void userBreak() throws TaskBreak {
        throw new TaskBreak();
    }

    protected static final class Request {
        int request;
        int arg1;
        int arg2;
        Object obj;
        int request_for_result;
        Object result;

        private Request() {
            this.request_for_result = 0;
            this.request = 0;
        }

        public Request(int _request, int _arg1, int _arg2, Object _obj) {
            this.request = _request;
            this.arg1 = _arg1;
            this.arg2 = _arg2;
            this.obj = _obj;
            this.request_for_result = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResult(Object result) {
            Request request = this;
            synchronized (request) {
                this.result = result;
                this.request_for_result = 0;
                this.request = 0;
                this.notifyAll();
            }
        }

        public boolean equals(Object o) {
            return o instanceof Request ? this.request == ((Request)o).request && this.request_for_result == ((Request)o).request_for_result && this.arg1 == ((Request)o).arg1 && this.arg2 == ((Request)o).arg2 && this.obj == ((Request)o).obj : super.equals(o);
        }
    }

    public static class TaskBreak
    extends RuntimeException {
    }
}

