/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.net;

import android.annotation.SuppressLint;
import android.util.Log;
import androidx.annotation.NonNull;
import com.jiangdg.net.AbstractChannelDataLink;
import com.jiangdg.net.NetworkHelper;
import com.jiangdg.utils.BuildCheck;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class SocketChannelDataLink
extends AbstractChannelDataLink {
    private static final boolean DEBUG = false;
    private static final String TAG = SocketChannelDataLink.class.getSimpleName();
    public static final int DEFAULT_SERVER_PORT = 6000;
    private ServerTask mServerTask;

    public SocketChannelDataLink() {
    }

    public SocketChannelDataLink(AbstractChannelDataLink.Callback callback) {
        super(callback);
    }

    @Override
    public void release() {
        this.stop();
        super.release();
    }

    public Client connectTo(String addr) throws IOException {
        return this.connectTo(addr, 6000);
    }

    public Client connectTo(String addr, int port) throws IOException {
        Client result;
        try {
            InetAddress address = InetAddress.getByName(addr);
            result = new Client(this, addr, port);
            this.add(result);
        }
        catch (UnknownHostException e) {
            throw new IOException(e.getMessage());
        }
        return result;
    }

    public synchronized boolean isRunning() {
        return this.mServerTask != null;
    }

    public void start() throws IllegalStateException {
        this.start(6000, null);
    }

    public void start(AbstractChannelDataLink.Callback callback) throws IllegalStateException {
        this.start(6000, callback);
    }

    public synchronized void start(int port, AbstractChannelDataLink.Callback callback) throws IllegalStateException {
        this.add(callback);
        if (this.mServerTask == null) {
            this.mServerTask = new ServerTask(port);
            new Thread(this.mServerTask).start();
        } else {
            Log.d((String)TAG, (String)"already started");
        }
    }

    public synchronized void stop() {
        if (this.mServerTask != null) {
            this.mServerTask.release();
            this.mServerTask = null;
        }
    }

    private class ServerTask
    implements Runnable {
        private final int mPort;
        private volatile boolean mIsRunning;
        private ServerSocketChannel mServerChannel;

        public ServerTask(int port) {
            this.mPort = port;
        }

        public synchronized void release() {
            this.mIsRunning = false;
            if (this.mServerChannel != null) {
                try {
                    this.mServerChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mServerChannel = null;
            }
        }

        @Override
        public void run() {
            try {
                this.init();
                while (this.mIsRunning) {
                    this.serverLoop();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            finally {
                this.release();
            }
        }

        @SuppressLint(value={"NewApi"})
        private synchronized void init() throws IOException {
            String addr = NetworkHelper.getLocalIPv4Address();
            InetSocketAddress address = new InetSocketAddress(addr, this.mPort);
            this.mServerChannel = ServerSocketChannel.open();
            if (BuildCheck.isNougat()) {
                this.mServerChannel.bind(address);
            } else {
                ServerSocket socket = this.mServerChannel.socket();
                socket.bind(address);
            }
            this.mIsRunning = true;
        }

        private void serverLoop() {
            while (this.mIsRunning) {
                try {
                    SocketChannel clientChannel = this.mServerChannel.accept();
                    Client client = new Client(SocketChannelDataLink.this, (ByteChannel)clientChannel);
                    SocketChannelDataLink.this.add(client);
                }
                catch (IOException e) {
                    break;
                }
            }
        }
    }

    public static class Client
    extends AbstractChannelDataLink.AbstractClient {
        private String mAddr;
        private int mPort;

        public Client(@NonNull SocketChannelDataLink parent, @NonNull ByteChannel channel) {
            super(parent, channel);
            this.internalStart();
        }

        public Client(@NonNull SocketChannelDataLink parent, String addr, int port) {
            super(parent, null);
            this.mAddr = addr;
            this.mPort = port;
            this.internalStart();
        }

        public synchronized String getAddress() {
            Socket socket = this.mChannel instanceof SocketChannel ? ((SocketChannel)this.mChannel).socket() : null;
            InetAddress address = socket != null ? socket.getInetAddress() : null;
            return address != null ? address.getHostAddress() : null;
        }

        public synchronized int getPort() {
            Socket socket = this.mChannel instanceof SocketChannel ? ((SocketChannel)this.mChannel).socket() : null;
            return socket != null ? socket.getPort() : 0;
        }

        public synchronized boolean isConnected() {
            return this.mChannel instanceof SocketChannel && ((SocketChannel)this.mChannel).isConnected();
        }

        @Override
        protected synchronized void init() throws IOException {
            try {
                if (this.mChannel == null) {
                    InetSocketAddress address = new InetSocketAddress(this.mAddr, this.mPort);
                    this.mChannel = SocketChannel.open(address);
                }
                this.setInit(true);
            }
            finally {
                this.notifyAll();
            }
        }
    }
}

