/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.net;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jiangdg.io.ChannelHelper;
import com.jiangdg.utils.HandlerThreadHandler;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractChannelDataLink {
    private static final boolean DEBUG = false;
    private static final String TAG = AbstractChannelDataLink.class.getSimpleName();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int REQ_RELEASE = -9;
    private static final int TYPE_UNKNOWN = -1;
    private static final int TYPE_NULL = 0;
    private static final int TYPE_BYTE_BUFFER = 1;
    private static final int TYPE_STRING = 2;
    private static final int TYPE_BOOL = 10;
    private static final int TYPE_INT = 11;
    private static final int TYPE_LONG = 12;
    private static final int TYPE_FLOAT = 20;
    private static final int TYPE_DOUBLE = 21;
    private static final int TYPE_BYTE_ARRAY = 30;
    private static final int TYPE_BOOL_ARRAY = 31;
    private static final int TYPE_INT_ARRAY = 32;
    private static final int TYPE_LONG_ARRAY = 33;
    private static final int TYPE_FLOAT_ARRAY = 40;
    private static final int TYPE_DOUBLE_ARRAY = 41;
    private final Set<AbstractClient> mClients = new CopyOnWriteArraySet<AbstractClient>();
    private final Set<Callback> mCallbacks = new CopyOnWriteArraySet<Callback>();

    public AbstractChannelDataLink() {
    }

    public AbstractChannelDataLink(Callback callback) {
        this();
        this.add(callback);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        for (AbstractClient client : this.mClients) {
            client.release();
        }
        this.mClients.clear();
    }

    public void add(Callback callback) {
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
    }

    public void remove(Callback callback) {
        this.mCallbacks.remove(callback);
    }

    protected void add(AbstractClient client) {
        if (client != null) {
            this.mClients.add(client);
        }
    }

    public void remove(AbstractClient client) {
        this.mClients.remove(client);
    }

    public static abstract class AbstractClient
    implements Runnable,
    Handler.Callback {
        private final WeakReference<AbstractChannelDataLink> mWeakParent;
        protected ByteChannel mChannel;
        private volatile boolean mIsRunning = true;
        private volatile boolean mIsInit;
        private Handler mSenderHandler;

        public AbstractClient(@NonNull AbstractChannelDataLink parent, @Nullable ByteChannel channel) {
            this.mWeakParent = new WeakReference<AbstractChannelDataLink>(parent);
            this.mSenderHandler = HandlerThreadHandler.createHandler(this);
            this.mChannel = channel;
        }

        protected void finalize() throws Throwable {
            try {
                this.release(-1L);
            }
            finally {
                super.finalize();
            }
        }

        public void release() {
            this.release(500L);
        }

        public synchronized void release(long delay) {
            if (this.mSenderHandler != null) {
                try {
                    if (delay > 0L) {
                        this.mSenderHandler.sendEmptyMessageDelayed(-9, delay);
                    } else {
                        this.mSenderHandler.sendEmptyMessage(-9);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void internalStart() {
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                new Thread(this).start();
                while (this.mIsRunning && !this.mIsInit) {
                    try {
                        this.wait(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalRelease() {
            ByteChannel channel;
            this.mIsInit = false;
            this.mIsRunning = false;
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                channel = this.mChannel;
                this.mChannel = null;
                this.notifyAll();
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            abstractClient = this;
            synchronized (abstractClient) {
                if (this.mSenderHandler != null) {
                    try {
                        this.mSenderHandler.getLooper().quit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mSenderHandler = null;
                }
            }
        }

        public void send(boolean value) throws IOException {
            this.send(10, value);
        }

        public synchronized void send(int value) throws IOException {
            this.send(11, value);
        }

        public void send(long value) throws IOException {
            this.send(12, value);
        }

        public void send(float value) throws IOException {
            this.send(20, Float.valueOf(value));
        }

        public void send(double value) throws IOException {
            this.send(21, value);
        }

        public void send(@NonNull String value) throws IOException {
            this.send(2, value);
        }

        public void send(@NonNull byte[] values) throws IOException {
            this.send(30, values);
        }

        public void sent(@NonNull boolean[] values) throws IOException {
            this.send(31, values);
        }

        public void send(@NonNull int[] values) throws IOException {
            this.send(32, values);
        }

        public void send(@NonNull long[] values) throws IOException {
            this.send(33, values);
        }

        public void send(@NonNull float[] values) throws IOException {
            this.send(40, values);
        }

        public void send(@NonNull double[] values) throws IOException {
            this.send(41, values);
        }

        public void send(@NonNull ByteBuffer value) throws IOException {
            this.send(1, value);
        }

        public void send(@Nullable Object value) throws IOException {
            if (value == null) {
                this.send(0, null);
            } else if (value instanceof ByteBuffer) {
                this.send(1, value);
            } else if (value instanceof String) {
                this.send(2, value);
            } else if (value instanceof CharSequence) {
                this.send(2, value.toString());
            } else if (value instanceof Boolean) {
                this.send(10, value);
            } else if (value instanceof Integer) {
                this.send(11, value);
            } else if (value instanceof Long) {
                this.send(12, value);
            } else if (value instanceof Float) {
                this.send(20, value);
            } else if (value instanceof Double) {
                this.send(21, value);
            } else if (value instanceof byte[]) {
                this.send(30, value);
            } else if (value instanceof boolean[]) {
                this.send(31, value);
            } else if (value instanceof int[]) {
                this.send(32, value);
            } else if (value instanceof long[]) {
                this.send(33, value);
            } else if (value instanceof float[]) {
                this.send(40, value);
            } else if (value instanceof double[]) {
                this.send(41, value);
            } else {
                throw new IOException("unknown type of object");
            }
        }

        private synchronized void send(int type, @Nullable Object msg) throws IOException {
            if (this.mSenderHandler == null || !this.mIsRunning || !this.mIsInit) {
                throw new IOException();
            }
            this.mSenderHandler.sendMessage(this.mSenderHandler.obtainMessage(type, msg));
        }

        protected abstract void init() throws IOException;

        protected void setInit(boolean init) {
            this.mIsInit = init;
        }

        @Override
        public void run() {
            try {
                this.init();
                this.callOnConnect();
                this.doReceiveLoop();
                this.callOnDisconnect();
            }
            catch (Exception e) {
                this.callOnError(e);
            }
            finally {
                this.mIsRunning = false;
                AbstractChannelDataLink parent = (AbstractChannelDataLink)this.mWeakParent.get();
                if (parent != null) {
                    parent.mClients.remove(this);
                }
                this.release(-1L);
            }
        }

        private void doReceiveLoop() throws IOException, ClassNotFoundException {
            while (this.mIsRunning) {
                try {
                    int type = ChannelHelper.readInt(this.mChannel);
                    switch (type) {
                        case 0: {
                            this.callOnReceive(null);
                            break;
                        }
                        case 1: {
                            this.callOnReceive(ChannelHelper.readByteBuffer(this.mChannel));
                            break;
                        }
                        case 10: {
                            this.callOnReceive(ChannelHelper.readBoolean(this.mChannel));
                            break;
                        }
                        case 11: {
                            this.callOnReceive(ChannelHelper.readInt(this.mChannel));
                            break;
                        }
                        case 12: {
                            this.callOnReceive(ChannelHelper.readLong(this.mChannel));
                            break;
                        }
                        case 20: {
                            this.callOnReceive(Float.valueOf(ChannelHelper.readFloat(this.mChannel)));
                            break;
                        }
                        case 21: {
                            this.callOnReceive(ChannelHelper.readDouble(this.mChannel));
                            break;
                        }
                        case 2: {
                            this.callOnReceive(ChannelHelper.readString(this.mChannel));
                            break;
                        }
                        case 30: {
                            this.callOnReceive(ChannelHelper.readByteArray(this.mChannel));
                            break;
                        }
                        case 31: {
                            this.callOnReceive(ChannelHelper.readBooleanArray(this.mChannel));
                            break;
                        }
                        case 32: {
                            this.callOnReceive(ChannelHelper.readIntArray(this.mChannel));
                            break;
                        }
                        case 33: {
                            this.callOnReceive(ChannelHelper.readLongArray(this.mChannel));
                            break;
                        }
                        case 40: {
                            this.callOnReceive(ChannelHelper.readFloatArray(this.mChannel));
                            break;
                        }
                        case 41: {
                            this.callOnReceive(ChannelHelper.readDoubleArray(this.mChannel));
                        }
                    }
                }
                catch (SocketException | ClosedChannelException e) {
                    break;
                }
                catch (IOException e) {
                    break;
                }
            }
        }

        protected void callOnConnect() {
            AbstractChannelDataLink parent = (AbstractChannelDataLink)this.mWeakParent.get();
            if (parent != null) {
                for (Callback callback : parent.mCallbacks) {
                    try {
                        callback.onConnect(this);
                    }
                    catch (Exception e) {
                        parent.mCallbacks.remove(callback);
                    }
                }
            }
        }

        protected void callOnDisconnect() {
            AbstractChannelDataLink parent = (AbstractChannelDataLink)this.mWeakParent.get();
            if (parent != null) {
                for (Callback callback : parent.mCallbacks) {
                    try {
                        callback.onDisconnect();
                    }
                    catch (Exception e) {
                        parent.mCallbacks.remove(callback);
                    }
                }
            }
        }

        protected void callOnReceive(@Nullable Object msg) {
            AbstractChannelDataLink parent = (AbstractChannelDataLink)this.mWeakParent.get();
            if (parent != null) {
                for (Callback callback : parent.mCallbacks) {
                    try {
                        callback.onReceive(this, msg);
                    }
                    catch (Exception e) {
                        parent.mCallbacks.remove(callback);
                    }
                }
            }
        }

        protected void callOnError(Exception err) {
            AbstractChannelDataLink parent = (AbstractChannelDataLink)this.mWeakParent.get();
            if (parent != null) {
                for (Callback callback : parent.mCallbacks) {
                    try {
                        callback.onError(this, err);
                    }
                    catch (Exception e) {
                        parent.mCallbacks.remove(callback);
                    }
                }
            }
        }

        public synchronized boolean handleMessage(Message msg) {
            if (!this.mIsRunning || this.mChannel == null) {
                return false;
            }
            try {
                switch (msg.what) {
                    case -9: {
                        this.internalRelease();
                        return true;
                    }
                }
                switch (msg.what) {
                    case 0: {
                        ChannelHelper.write(this.mChannel, 0);
                        return true;
                    }
                    case 1: {
                        if (msg.obj instanceof ByteBuffer) {
                            ChannelHelper.write(this.mChannel, 1);
                            ChannelHelper.write(this.mChannel, (ByteBuffer)msg.obj);
                        }
                        return true;
                    }
                    case 10: {
                        if (!(msg.obj instanceof Boolean)) break;
                        ChannelHelper.write(this.mChannel, 10);
                        ChannelHelper.write(this.mChannel, (Boolean)msg.obj);
                        return true;
                    }
                    case 11: {
                        if (!(msg.obj instanceof Integer)) break;
                        ChannelHelper.write(this.mChannel, 11);
                        ChannelHelper.write(this.mChannel, (Integer)msg.obj);
                        return true;
                    }
                    case 12: {
                        if (!(msg.obj instanceof Long)) break;
                        ChannelHelper.write(this.mChannel, 12);
                        ChannelHelper.write(this.mChannel, (Long)msg.obj);
                        return true;
                    }
                    case 20: {
                        if (!(msg.obj instanceof Float)) break;
                        ChannelHelper.write(this.mChannel, 20);
                        ChannelHelper.write(this.mChannel, ((Float)msg.obj).floatValue());
                        return true;
                    }
                    case 21: {
                        if (!(msg.obj instanceof Double)) break;
                        ChannelHelper.write(this.mChannel, 21);
                        ChannelHelper.write(this.mChannel, (Double)msg.obj);
                        return true;
                    }
                    case 2: {
                        if (!(msg.obj instanceof String)) break;
                        ChannelHelper.write(this.mChannel, 2);
                        ChannelHelper.write(this.mChannel, (String)msg.obj);
                        return true;
                    }
                    case 30: {
                        if (!(msg.obj instanceof byte[])) break;
                        ChannelHelper.write(this.mChannel, 30);
                        ChannelHelper.write(this.mChannel, (byte[])msg.obj);
                        return true;
                    }
                    case 31: {
                        if (!(msg.obj instanceof boolean[])) break;
                        ChannelHelper.write(this.mChannel, 31);
                        ChannelHelper.write(this.mChannel, (boolean[])msg.obj);
                        return true;
                    }
                    case 32: {
                        if (!(msg.obj instanceof int[])) break;
                        ChannelHelper.write(this.mChannel, 32);
                        ChannelHelper.write(this.mChannel, (int[])msg.obj);
                        return true;
                    }
                    case 33: {
                        if (!(msg.obj instanceof long[])) break;
                        ChannelHelper.write(this.mChannel, 33);
                        ChannelHelper.write(this.mChannel, (long[])msg.obj);
                        return true;
                    }
                    case 40: {
                        if (!(msg.obj instanceof float[])) break;
                        ChannelHelper.write(this.mChannel, 40);
                        ChannelHelper.write(this.mChannel, (float[])msg.obj);
                        return true;
                    }
                    case 41: {
                        if (!(msg.obj instanceof double[])) break;
                        ChannelHelper.write(this.mChannel, 41);
                        ChannelHelper.write(this.mChannel, (double[])msg.obj);
                        return true;
                    }
                }
            }
            catch (SocketException socketException) {
            }
            catch (IOException e) {
                this.callOnError(e);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            return false;
        }
    }

    public static interface Callback {
        public void onConnect(AbstractClient var1);

        public void onDisconnect();

        public void onReceive(AbstractClient var1, @Nullable Object var2);

        public void onError(AbstractClient var1, Exception var2);
    }
}

