/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.mediastore;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import androidx.annotation.NonNull;
import com.jiangdg.utils.ThreadPool;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.FutureTask;

@TargetApi(value=16)
public class MediaStoreHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaStoreHelper.class.getSimpleName();
    public static final int MEDIA_ALL = 0;
    public static final int MEDIA_IMAGE = 1;
    public static final int MEDIA_VIDEO = 2;
    protected static final int MEDIA_TYPE_NUM = 3;
    protected static final String[] PROJ_MEDIA = new String[]{"_id", "title", "media_type", "mime_type", "_data", "_display_name", "width", "height"};
    protected static final String SELECTION_MEDIA_ALL = "media_type=1 OR media_type=3";
    protected static final String SELECTION_MEDIA_IMAGE = "media_type=1";
    protected static final String SELECTION_MEDIA_VIDEO = "media_type=3";
    protected static final String[] SELECTIONS = new String[]{"media_type=1 OR media_type=3", "media_type=1", "media_type=3"};
    protected static final int PROJ_INDEX_ID = 0;
    protected static final int PROJ_INDEX_TITLE = 1;
    protected static final int PROJ_INDEX_MEDIA_TYPE = 2;
    protected static final int PROJ_INDEX_MIME_TYPE = 3;
    protected static final int PROJ_INDEX_DATA = 4;
    protected static final int PROJ_INDEX_DISPLAY_NAME = 5;
    protected static final int PROJ_INDEX_WIDTH = 6;
    protected static final int PROJ_INDEX_HEIGHT = 7;
    protected static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Bitmap getImage(ContentResolver cr, long id2, int requestWidth, int requestHeight) throws IOException {
        Bitmap result = null;
        ParcelFileDescriptor pfd = cr.openFileDescriptor(ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)id2), "r");
        if (pfd != null) {
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor(), null, (BitmapFactory.Options)options);
                options.inSampleSize = MediaStoreHelper.calcSampleSize(options, requestWidth, requestHeight);
                options.inJustDecodeBounds = false;
                result = BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor(), null, (BitmapFactory.Options)options);
            }
            finally {
                pfd.close();
            }
        }
        return result;
    }

    protected static final int calcSampleSize(BitmapFactory.Options options, int requestWidth, int requestHeight) {
        int imageWidth = options.outWidth;
        int imageHeight = options.outHeight;
        int reqWidth = requestWidth;
        int reqHeight = requestHeight;
        if (requestWidth <= 0) {
            reqWidth = requestHeight > 0 ? (int)((float)(imageWidth * requestHeight) / (float)imageHeight) : imageWidth;
        }
        if (requestHeight <= 0) {
            reqHeight = requestWidth > 0 ? (int)((float)(imageHeight * requestWidth) / (float)imageHeight) : imageHeight;
        }
        int inSampleSize = 1;
        if (imageHeight > reqHeight || imageWidth > reqWidth) {
            inSampleSize = imageWidth > imageHeight ? Math.round((float)imageHeight / (float)reqHeight) : Math.round((float)imageWidth / (float)reqWidth);
        }
        return inSampleSize;
    }

    protected static abstract class ImageLoader
    implements Runnable {
        protected final LoaderDrawable mParent;
        private final FutureTask<Bitmap> mTask;
        private int mMediaType;
        private int mHashCode;
        private long mId;
        private Bitmap mBitmap;

        public ImageLoader(LoaderDrawable parent) {
            this.mParent = parent;
            this.mTask = new FutureTask<Object>(this, null);
        }

        public synchronized void startLoad(int media_type, int hashCode, long id2) {
            this.mMediaType = media_type;
            this.mHashCode = hashCode;
            this.mId = id2;
            this.mBitmap = null;
            ThreadPool.queueEvent(this.mTask);
        }

        public void cancelLoad() {
            this.mTask.cancel(true);
        }

        protected abstract Bitmap loadBitmap(ContentResolver var1, int var2, int var3, long var4, int var6, int var7);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long id2;
            int hashCode;
            int mediaType;
            ImageLoader imageLoader = this;
            synchronized (imageLoader) {
                mediaType = this.mMediaType;
                hashCode = this.mHashCode;
                id2 = this.mId;
            }
            if (!this.mTask.isCancelled()) {
                this.mBitmap = this.loadBitmap(this.mParent.mContentResolver, mediaType, hashCode, id2, this.mParent.mWidth, this.mParent.mHeight);
            }
            if (this.mTask.isCancelled() || id2 != this.mId || this.mBitmap == null) {
                return;
            }
            this.mParent.scheduleSelf(this.mParent, 0L);
        }

        public Bitmap getBitmap() {
            return this.mBitmap;
        }
    }

    protected static abstract class LoaderDrawable
    extends Drawable
    implements Runnable {
        private final ContentResolver mContentResolver;
        private final Paint mPaint = new Paint();
        private final Paint mDebugPaint = new Paint();
        private final Matrix mDrawMatrix = new Matrix();
        private Bitmap mBitmap;
        private int mRotation = 0;
        private ImageLoader mLoader;
        private final int mWidth;
        private final int mHeight;

        public LoaderDrawable(ContentResolver cr, int width, int height) {
            this.mContentResolver = cr;
            this.mDebugPaint.setColor(-65536);
            this.mDebugPaint.setTextSize(18.0f);
            this.mWidth = width;
            this.mHeight = height;
        }

        protected void onBoundsChange(Rect bounds) {
            super.onBoundsChange(bounds);
            this.updateDrawMatrix(this.getBounds());
        }

        public void draw(@NonNull Canvas canvas) {
            Rect bounds = this.getBounds();
            if (this.mBitmap != null) {
                canvas.save();
                canvas.clipRect(bounds);
                canvas.concat(this.mDrawMatrix);
                canvas.rotate((float)this.mRotation, (float)bounds.centerX(), (float)bounds.centerY());
                canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mPaint);
                canvas.restore();
            } else {
                this.mPaint.setColor(-3355444);
                canvas.drawRect(bounds, this.mPaint);
            }
        }

        private void updateDrawMatrix(Rect bounds) {
            float scale;
            if (this.mBitmap == null || bounds.isEmpty()) {
                this.mDrawMatrix.reset();
                return;
            }
            float dwidth = this.mBitmap.getWidth();
            float dheight = this.mBitmap.getHeight();
            int vwidth = bounds.width();
            int vheight = bounds.height();
            int dx = 0;
            int dy = 0;
            if (dwidth * (float)vheight > (float)vwidth * dheight) {
                scale = (float)vheight / dheight;
                dx = (int)(((float)vwidth - dwidth * scale) * 0.5f + 0.5f);
            } else {
                scale = (float)vwidth / dwidth;
                dy = (int)(((float)vheight - dheight * scale) * 0.5f + 0.5f);
            }
            this.mDrawMatrix.setScale(scale, scale);
            this.mDrawMatrix.postTranslate((float)dx, (float)dy);
            this.invalidateSelf();
        }

        public void setAlpha(int alpha) {
            int oldAlpha = this.mPaint.getAlpha();
            if (alpha != oldAlpha) {
                this.mPaint.setAlpha(alpha);
                this.invalidateSelf();
            }
        }

        public void setColorFilter(ColorFilter cf) {
            this.mPaint.setColorFilter(cf);
            this.invalidateSelf();
        }

        public int getIntrinsicWidth() {
            return this.mWidth;
        }

        public int getIntrinsicHeight() {
            return this.mHeight;
        }

        public int getOpacity() {
            Bitmap bm = this.mBitmap;
            return bm == null || bm.hasAlpha() || this.mPaint.getAlpha() < 255 ? -3 : -1;
        }

        @Override
        public void run() {
            this.setBitmap(this.mLoader.getBitmap());
        }

        protected abstract ImageLoader createThumbnailLoader();

        protected abstract Bitmap checkBitmapCache(int var1, long var2);

        public void startLoad(int media_type, int hashCode, long id2) {
            Bitmap newBitmap;
            if (this.mLoader != null) {
                this.mLoader.cancelLoad();
            }
            if ((newBitmap = this.checkBitmapCache(hashCode, id2)) == null) {
                this.mBitmap = null;
                this.mLoader = this.createThumbnailLoader();
                this.mLoader.startLoad(media_type, hashCode, id2);
            } else {
                this.setBitmap(newBitmap);
            }
            this.invalidateSelf();
        }

        private void setBitmap(Bitmap bitmap) {
            if (bitmap != this.mBitmap) {
                this.mBitmap = bitmap;
                this.updateDrawMatrix(this.getBounds());
            }
        }
    }

    public static class MediaInfo {
        public long id;
        public String data;
        public String title;
        public String mime;
        public String displayName;
        public int mediaType;
        public int width;
        public int height;

        protected MediaInfo loadFromCursor(Cursor cursor) {
            if (cursor != null) {
                this.id = cursor.getLong(0);
                this.data = cursor.getString(4);
                this.title = cursor.getString(1);
                this.mime = cursor.getString(3);
                this.displayName = cursor.getString(5);
                this.mediaType = cursor.getInt(2);
                try {
                    this.width = cursor.getInt(6);
                    this.height = cursor.getInt(7);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this;
        }

        @NonNull
        public String toString() {
            return String.format("MediaInfo(title=%s,displayName=%s, mediaType=%s,mime=%s,data=%s)", this.title, this.displayName, this.mediaType(), this.mime, this.data);
        }

        private String mediaType() {
            switch (this.mediaType) {
                case 0: {
                    return "none";
                }
                case 1: {
                    return "image";
                }
                case 2: {
                    return "audio";
                }
                case 3: {
                    return "video";
                }
                case 4: {
                    return "playlist";
                }
            }
            return String.format(Locale.US, "unknown:%d", this.mediaType);
        }
    }
}

