/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.mediastore;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.provider.MediaStore;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.collection.LruCache;
import androidx.cursoradapter.widget.CursorAdapter;
import com.jiangdg.common.R;
import com.jiangdg.mediastore.MediaStoreHelper;
import com.jiangdg.utils.ThreadPool;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MediaStoreAdapter
extends CursorAdapter {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaStoreAdapter.class.getSimpleName();
    private static final int CACHE_RATE = 8;
    private static LruCache<String, Bitmap> sThumbnailCache;
    private int mThumbnailWidth = 200;
    private int mThumbnailHeight = 200;
    private final LayoutInflater mInflater;
    private final ContentResolver mCr;
    private final int mMemClass;
    private final int mLayoutId;
    private final MyAsyncQueryHandler mQueryHandler;
    private final int mHashCode = ((Object)((Object)this)).hashCode();
    private Cursor mMediaInfoCursor;
    private String mSelection;
    private String[] mSelectionArgs;
    private boolean mShowTitle = false;
    private int mMediaType = 0;
    private final MediaStoreHelper.MediaInfo info = new MediaStoreHelper.MediaInfo();

    public MediaStoreAdapter(Context context, int id_layout) {
        super(context, null, 2);
        this.mInflater = LayoutInflater.from((Context)context);
        this.mCr = context.getContentResolver();
        this.mQueryHandler = new MyAsyncQueryHandler(this.mCr, this);
        this.mMemClass = ((ActivityManager)context.getSystemService("activity")).getMemoryClass();
        this.mLayoutId = id_layout;
        this.onContentChanged();
    }

    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        View view = this.mInflater.inflate(this.mLayoutId, parent, false);
        this.getViewHolder(view);
        return view;
    }

    protected MediaStoreHelper.LoaderDrawable createLoaderDrawable(ContentResolver cr) {
        return new ThumbnailLoaderDrawable(cr, this.mThumbnailWidth, this.mThumbnailHeight);
    }

    public void bindView(View view, Context context, Cursor cursor) {
        ViewHolder holder = this.getViewHolder(view);
        ImageView iv = holder.mImageView;
        TextView tv = holder.mTitleView;
        Drawable drawable2 = iv.getDrawable();
        if (!(drawable2 instanceof MediaStoreHelper.LoaderDrawable)) {
            drawable2 = this.createLoaderDrawable(this.mCr);
            iv.setImageDrawable(drawable2);
        }
        ((MediaStoreHelper.LoaderDrawable)drawable2).startLoad(cursor.getInt(2), this.mHashCode, cursor.getLong(0));
        if (tv != null) {
            tv.setVisibility(this.mShowTitle ? 0 : 8);
            if (this.mShowTitle) {
                tv.setText((CharSequence)cursor.getString(1));
            }
        }
    }

    private ViewHolder getViewHolder(View view) {
        ViewHolder holder = (ViewHolder)view.getTag(R.id.mediastorephotoadapter);
        if (holder == null) {
            holder = new ViewHolder();
            if (view instanceof ImageView) {
                holder.mImageView = (ImageView)view;
                view.setTag(R.id.mediastorephotoadapter, (Object)holder);
            } else {
                View v = view.findViewById(R.id.thumbnail);
                if (v instanceof ImageView) {
                    holder.mImageView = (ImageView)v;
                }
                if ((v = view.findViewById(R.id.title)) instanceof TextView) {
                    holder.mTitleView = (TextView)v;
                }
                view.setTag(R.id.mediastorephotoadapter, (Object)holder);
            }
        }
        return holder;
    }

    protected void finalize() throws Throwable {
        this.changeCursor(null);
        if (this.mMediaInfoCursor != null) {
            this.mMediaInfoCursor.close();
            this.mMediaInfoCursor = null;
        }
        super.finalize();
    }

    protected void onContentChanged() {
        this.createBitmapCache(false);
        this.mQueryHandler.requery();
    }

    public Bitmap getItem(int position) {
        Bitmap result = null;
        this.getMediaInfo(position, this.info);
        if (this.info.mediaType == 1) {
            try {
                result = MediaStoreAdapter.getImageThumbnail(this.mCr, this.mHashCode, this.getItemId(position), this.mThumbnailWidth, this.mThumbnailHeight);
            }
            catch (FileNotFoundException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        } else if (this.info.mediaType == 3) {
            try {
                result = MediaStoreAdapter.getVideoThumbnail(this.mCr, this.mHashCode, this.getItemId(position), this.mThumbnailWidth, this.mThumbnailHeight);
            }
            catch (FileNotFoundException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return result;
    }

    public int getPositionFromId(long id2) {
        int result = -1;
        int n = this.getCount();
        MediaStoreHelper.MediaInfo info = new MediaStoreHelper.MediaInfo();
        for (int i = 0; i < n; ++i) {
            this.getMediaInfo(i, info);
            if (info.id != id2) continue;
            result = i;
            break;
        }
        return result;
    }

    public Bitmap getImage(int position, int width, int height) throws FileNotFoundException, IOException {
        return MediaStoreHelper.getImage(this.mCr, this.getItemId(position), width, height);
    }

    public MediaStoreHelper.MediaInfo getMediaInfo(int position) {
        return this.getMediaInfo(position, null);
    }

    public synchronized MediaStoreHelper.MediaInfo getMediaInfo(int position, MediaStoreHelper.MediaInfo info) {
        MediaStoreHelper.MediaInfo _info;
        MediaStoreHelper.MediaInfo mediaInfo = _info = info != null ? info : new MediaStoreHelper.MediaInfo();
        if (this.mMediaInfoCursor == null) {
            this.mMediaInfoCursor = this.mCr.query(MediaStoreHelper.QUERY_URI, MediaStoreHelper.PROJ_MEDIA, this.mSelection, this.mSelectionArgs, null);
        }
        if (this.mMediaInfoCursor.moveToPosition(position)) {
            _info.loadFromCursor(this.mMediaInfoCursor);
        }
        return _info;
    }

    public void setThumbnailSize(int size) {
        if (this.mThumbnailWidth != size || this.mThumbnailHeight != size) {
            this.mThumbnailWidth = this.mThumbnailHeight = size;
            this.createBitmapCache(true);
            this.onContentChanged();
        }
    }

    public void setThumbnailSize(int width, int height) {
        if (this.mThumbnailWidth != width || this.mThumbnailHeight != height) {
            this.mThumbnailWidth = width;
            this.mThumbnailHeight = height;
            this.createBitmapCache(true);
            this.onContentChanged();
        }
    }

    public void setShowTitle(boolean showTitle) {
        if (this.mShowTitle != showTitle) {
            this.mShowTitle = showTitle;
            this.onContentChanged();
        }
    }

    public boolean getShowTitle() {
        return this.mShowTitle;
    }

    public int getMediaType() {
        return this.mMediaType % 3;
    }

    public void setMediaType(int media_type) {
        if (this.mMediaType != media_type % 3) {
            this.mMediaType = media_type % 3;
            this.onContentChanged();
        }
    }

    public static void destroy() {
        if (sThumbnailCache != null) {
            sThumbnailCache.evictAll();
            sThumbnailCache = null;
        }
    }

    @SuppressLint(value={"NewApi"})
    private final void createBitmapCache(boolean clear) {
        if (clear && sThumbnailCache != null) {
            MediaStoreAdapter.clearBitmapCache(((Object)((Object)this)).hashCode());
        }
        if (sThumbnailCache == null) {
            int cacheSize = 0x100000 * this.mMemClass / 8;
            sThumbnailCache = new LruCache<String, Bitmap>(cacheSize){

                protected int sizeOf(@NonNull String key, @NonNull Bitmap bitmap) {
                    return bitmap.getRowBytes() * bitmap.getHeight();
                }
            };
        }
        ThreadPool.preStartAllCoreThreads();
    }

    private static void clearBitmapCache(int hashCode) {
        if (sThumbnailCache != null) {
            if (hashCode != 0) {
                Map snapshot = sThumbnailCache.snapshot();
                String key_prefix = String.format(Locale.US, "%d_", hashCode);
                Set keys = snapshot.keySet();
                for (String key : keys) {
                    if (!key.startsWith(key_prefix)) continue;
                    sThumbnailCache.remove((Object)key);
                }
            } else {
                sThumbnailCache.evictAll();
            }
            System.gc();
        }
    }

    private static String getKey(long hashCode, long id2) {
        return String.format(Locale.US, "%d_%d", hashCode, id2);
    }

    private static final Bitmap getImageThumbnail(ContentResolver cr, long hashCode, long id2, int requestWidth, int requestHeight) throws IOException {
        String key = MediaStoreAdapter.getKey(hashCode, id2);
        Bitmap result = (Bitmap)sThumbnailCache.get((Object)key);
        if (result == null) {
            if (requestWidth <= 0 || requestHeight <= 0) {
                result = MediaStoreHelper.getImage(cr, id2, requestWidth, requestHeight);
            } else {
                BitmapFactory.Options options = null;
                int kind = 3;
                if (requestWidth > 96 || requestHeight > 96 || requestWidth * requestHeight > 16384) {
                    kind = 1;
                }
                try {
                    result = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)cr, (long)id2, (int)kind, options);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (result != null) {
                sThumbnailCache.put((Object)key, (Object)result);
            }
        }
        return result;
    }

    private static final Bitmap getVideoThumbnail(ContentResolver cr, long hashCode, long id2, int requestWidth, int requestHeight) throws FileNotFoundException, IOException {
        String key = MediaStoreAdapter.getKey(hashCode, id2);
        Bitmap result = (Bitmap)sThumbnailCache.get((Object)key);
        if (result == null) {
            BitmapFactory.Options options = null;
            int kind = 3;
            if (requestWidth > 96 || requestHeight > 96 || requestWidth * requestHeight > 16384) {
                kind = 1;
            }
            try {
                result = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)cr, (long)id2, (int)kind, options);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result != null) {
                sThumbnailCache.put((Object)key, (Object)result);
            } else {
                Log.w((String)TAG, (String)("failed to get video thumbnail ofr id=" + id2));
            }
        }
        return result;
    }

    static /* synthetic */ String[] access$402(MediaStoreAdapter x0, String[] x1) {
        x0.mSelectionArgs = x1;
        return x1;
    }

    private static class ThumbnailLoader
    extends MediaStoreHelper.ImageLoader {
        public ThumbnailLoader(ThumbnailLoaderDrawable parent) {
            super(parent);
        }

        @Override
        protected Bitmap loadBitmap(ContentResolver cr, int mediaType, int hashCode, long id2, int requestWidth, int requestHeight) {
            Bitmap result = null;
            try {
                switch (mediaType) {
                    case 1: {
                        result = MediaStoreAdapter.getImageThumbnail(cr, hashCode, id2, requestWidth, requestHeight);
                        break;
                    }
                    case 3: {
                        result = MediaStoreAdapter.getVideoThumbnail(cr, hashCode, id2, requestWidth, requestHeight);
                    }
                }
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            return result;
        }
    }

    private static class ThumbnailLoaderDrawable
    extends MediaStoreHelper.LoaderDrawable {
        public ThumbnailLoaderDrawable(ContentResolver cr, int width, int height) {
            super(cr, width, height);
        }

        @Override
        protected MediaStoreHelper.ImageLoader createThumbnailLoader() {
            return new ThumbnailLoader(this);
        }

        @Override
        protected Bitmap checkBitmapCache(int hashCode, long id2) {
            return (Bitmap)sThumbnailCache.get((Object)MediaStoreAdapter.getKey(hashCode, id2));
        }
    }

    private static final class ViewHolder {
        TextView mTitleView;
        ImageView mImageView;

        private ViewHolder() {
        }
    }

    private static final class MyAsyncQueryHandler
    extends AsyncQueryHandler {
        private final MediaStoreAdapter mAdapter;

        public MyAsyncQueryHandler(ContentResolver cr, MediaStoreAdapter adapter) {
            super(cr);
            this.mAdapter = adapter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requery() {
            MediaStoreAdapter mediaStoreAdapter = this.mAdapter;
            synchronized (mediaStoreAdapter) {
                if (this.mAdapter.mMediaInfoCursor != null) {
                    this.mAdapter.mMediaInfoCursor.close();
                    this.mAdapter.mMediaInfoCursor = null;
                }
                this.mAdapter.mSelection = MediaStoreHelper.SELECTIONS[this.mAdapter.mMediaType % 3];
                MediaStoreAdapter.access$402(this.mAdapter, null);
                this.startQuery(0, (Object)this.mAdapter, MediaStoreHelper.QUERY_URI, MediaStoreHelper.PROJ_MEDIA, this.mAdapter.mSelection, this.mAdapter.mSelectionArgs, null);
            }
        }

        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            Cursor oldCursor = this.mAdapter.swapCursor(cursor);
            if (oldCursor != null && !oldCursor.isClosed()) {
                oldCursor.close();
            }
        }
    }
}

