/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.mediaeffect;

import android.graphics.Matrix;
import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.jiangdg.glutils.GLHelper;
import com.jiangdg.mediaeffect.MediaEffectDrawer;
import com.jiangdg.mediaeffect.MediaEffectGLESBase;

public class MediaEffectTexProjection
extends MediaEffectGLESBase {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaEffectTexProjection";
    public static final String PROJ_VERTEX_SHADER = "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nuniform mat3 uTexMatrix2;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\ngl_Position = uMVPMatrix * aPosition;\nvec3 tex_coord = vec3((uTexMatrix * aTextureCoord).xy, 1.0);\nvec3 temp = uTexMatrix2 * tex_coord;\nvTextureCoord = temp.xy / temp.z;\n}\n";
    private static final String FRAGMENT_SHADER_BASE = "#version 100\n%s#define KERNEL_SIZE3x3 9\nprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nvoid main() {\ngl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final String FRAGMENT_SHADER = String.format("#version 100\n%s#define KERNEL_SIZE3x3 9\nprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nvoid main() {\ngl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n", "", "sampler2D");
    private static final String FRAGMENT_SHADER_EXT = String.format("#version 100\n%s#define KERNEL_SIZE3x3 9\nprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nvoid main() {\ngl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private final Matrix mat = new Matrix();
    private final float[] m = new float[9];

    public MediaEffectTexProjection() {
        super(new MediaEffectTexProjectionDrawer(PROJ_VERTEX_SHADER, FRAGMENT_SHADER));
    }

    public void calcPerspectiveTransform(float[] src, float[] dst) {
        this.mat.reset();
        this.mat.setPolyToPoly(src, 0, dst, 0, 4);
        this.mat.getValues(this.m);
        ((MediaEffectTexProjectionDrawer)this.mDrawer).setTexProjection(this.m);
    }

    private static class MediaEffectTexProjectionDrawer
    extends MediaEffectDrawer.MediaEffectSingleDrawer {
        private float[] texMatrix2 = new float[9];
        private final int muTexMatrixLoc2 = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"uTexMatrix2");

        public MediaEffectTexProjectionDrawer(String vss, String fss) {
            super(false, vss, fss);
            GLHelper.checkLocation(this.muTexMatrixLoc2, "uTexMatrix2");
            this.reset();
        }

        @Override
        protected void preDraw(@NonNull int[] tex_ids, float[] tex_matrix, int offset) {
            if (this.muTexMatrixLoc2 >= 0) {
                GLES20.glUniformMatrix3fv((int)this.muTexMatrixLoc2, (int)1, (boolean)false, (float[])this.texMatrix2, (int)0);
                GLHelper.checkGlError("glUniformMatrix3fv");
            }
            super.preDraw(tex_ids, tex_matrix, offset);
        }

        public void reset() {
            this.setTexProjection(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTexProjection(float[] matrix) {
            Object object = this.mSync;
            synchronized (object) {
            }
        }
    }
}

