/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.mediaeffect;

import androidx.annotation.NonNull;
import com.jiangdg.glutils.TextureOffscreen;
import com.jiangdg.mediaeffect.IEffect;
import com.jiangdg.mediaeffect.ISource;
import com.jiangdg.mediaeffect.MediaEffectDrawer;

public class MediaEffectGLESBase
implements IEffect {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaEffectGLESBase";
    protected TextureOffscreen mOutputOffscreen;
    protected volatile boolean mEnabled = true;
    protected final MediaEffectDrawer mDrawer;

    public MediaEffectGLESBase(int numTex, String shader) {
        this(MediaEffectDrawer.newInstance(numTex, false, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", shader));
    }

    public MediaEffectGLESBase(int numTex, boolean isOES, String shader) {
        this(MediaEffectDrawer.newInstance(numTex, isOES, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", shader));
    }

    public MediaEffectGLESBase(int numTex, boolean isOES, String vss, String fss) {
        this(MediaEffectDrawer.newInstance(numTex, isOES, vss, fss));
    }

    public MediaEffectGLESBase(MediaEffectDrawer drawer) {
        this.mDrawer = drawer;
    }

    @Override
    public void release() {
        this.mDrawer.release();
        if (this.mOutputOffscreen != null) {
            this.mOutputOffscreen.release();
            this.mOutputOffscreen = null;
        }
    }

    public float[] getMvpMatrix() {
        return this.mDrawer.getMvpMatrix();
    }

    public MediaEffectGLESBase setMvpMatrix(float[] matrix, int offset) {
        this.mDrawer.setMvpMatrix(matrix, offset);
        return this;
    }

    public void getMvpMatrix(float[] matrix, int offset) {
        this.mDrawer.getMvpMatrix(matrix, offset);
    }

    @Override
    public MediaEffectGLESBase resize(int width, int height) {
        if (this.mDrawer != null) {
            this.mDrawer.setTexSize(width, height);
        }
        return this;
    }

    @Override
    public boolean enabled() {
        return this.mEnabled;
    }

    @Override
    public IEffect setEnable(boolean enable) {
        this.mEnabled = enable;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(@NonNull int[] src_tex_ids, int width, int height, int out_tex_id) {
        if (!this.mEnabled) {
            return;
        }
        if (this.mOutputOffscreen == null) {
            this.mOutputOffscreen = new TextureOffscreen(width, height, false);
        }
        if (out_tex_id != this.mOutputOffscreen.getTexture() || width != this.mOutputOffscreen.getWidth() || height != this.mOutputOffscreen.getHeight()) {
            this.mOutputOffscreen.assignTexture(out_tex_id, width, height);
        }
        this.mOutputOffscreen.bind();
        try {
            this.mDrawer.apply(src_tex_ids, this.mOutputOffscreen.getTexMatrix(), 0);
        }
        finally {
            this.mOutputOffscreen.unbind();
        }
    }

    @Override
    public void apply(@NonNull int[] src_tex_ids, @NonNull TextureOffscreen output) {
        if (!this.mEnabled) {
            return;
        }
        output.bind();
        try {
            this.mDrawer.apply(src_tex_ids, output.getTexMatrix(), 0);
        }
        finally {
            output.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(ISource src) {
        if (!this.mEnabled) {
            return;
        }
        TextureOffscreen output_tex = src.getOutputTexture();
        int[] src_tex_ids = src.getSourceTexId();
        output_tex.bind();
        try {
            this.mDrawer.apply(src_tex_ids, output_tex.getTexMatrix(), 0);
        }
        finally {
            output_tex.unbind();
        }
    }

    protected int getProgram() {
        return this.mDrawer.getProgram();
    }
}

