/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.mediaeffect;

import com.jiangdg.mediaeffect.MediaEffectGLESBase;
import com.jiangdg.mediaeffect.MediaEffectKernel3x3Drawer;

public class MediaEffectExtraction
extends MediaEffectGLESBase {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaEffectExtraction";
    private static final String FRAGMENT_SHADER_BASE = "#version 100\n%s#define KERNEL_SIZE3x3 9\nprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform float uKernel[18];\nuniform vec2  uTexOffset[KERNEL_SIZE3x3];\nuniform float uColorAdjust;\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    vec3 min = vec3(uKernel[0], uKernel[2], uKernel[4]);\n    vec3 max = vec3(uKernel[1], uKernel[3], uKernel[5]);\n    vec3 add = vec3(uKernel[6], uKernel[7], uKernel[8]);\n    float e = 1e-10;\n    vec3 eps = vec3(e, e, e);\n    vec3 v = hsv;\n    if (hsv.r < min.r || hsv.r > max.r || hsv.g < min.g || hsv.g > max.g || hsv.b < min.b || hsv.b > max.b) {\n        v = vec3(0.0);\n    }\n    hsv = v + add;\n    if (uColorAdjust > 0.0) {\n        hsv = step(vec3(1.0, 1.0, uColorAdjust), hsv);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER = String.format("#version 100\n%s#define KERNEL_SIZE3x3 9\nprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform float uKernel[18];\nuniform vec2  uTexOffset[KERNEL_SIZE3x3];\nuniform float uColorAdjust;\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    vec3 min = vec3(uKernel[0], uKernel[2], uKernel[4]);\n    vec3 max = vec3(uKernel[1], uKernel[3], uKernel[5]);\n    vec3 add = vec3(uKernel[6], uKernel[7], uKernel[8]);\n    float e = 1e-10;\n    vec3 eps = vec3(e, e, e);\n    vec3 v = hsv;\n    if (hsv.r < min.r || hsv.r > max.r || hsv.g < min.g || hsv.g > max.g || hsv.b < min.b || hsv.b > max.b) {\n        v = vec3(0.0);\n    }\n    hsv = v + add;\n    if (uColorAdjust > 0.0) {\n        hsv = step(vec3(1.0, 1.0, uColorAdjust), hsv);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n", "", "sampler2D");
    private static final String FRAGMENT_SHADER_EXT = String.format("#version 100\n%s#define KERNEL_SIZE3x3 9\nprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform float uKernel[18];\nuniform vec2  uTexOffset[KERNEL_SIZE3x3];\nuniform float uColorAdjust;\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    vec3 min = vec3(uKernel[0], uKernel[2], uKernel[4]);\n    vec3 max = vec3(uKernel[1], uKernel[3], uKernel[5]);\n    vec3 add = vec3(uKernel[6], uKernel[7], uKernel[8]);\n    float e = 1e-10;\n    vec3 eps = vec3(e, e, e);\n    vec3 v = hsv;\n    if (hsv.r < min.r || hsv.r > max.r || hsv.g < min.g || hsv.g > max.g || hsv.b < min.b || hsv.b > max.b) {\n        v = vec3(0.0);\n    }\n    hsv = v + add;\n    if (uColorAdjust > 0.0) {\n        hsv = step(vec3(1.0, 1.0, uColorAdjust), hsv);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private final float[] mLimit = new float[9];

    public MediaEffectExtraction() {
        super(new MediaEffectKernel3x3Drawer(FRAGMENT_SHADER));
        this.mLimit[0] = 0.0f;
        this.mLimit[1] = 1.0f;
        this.mLimit[2] = 0.0f;
        this.mLimit[3] = 1.0f;
        this.mLimit[4] = 0.0f;
        this.mLimit[5] = 1.0f;
        this.mLimit[6] = 0.0f;
        this.mLimit[7] = 0.0f;
        this.mLimit[8] = 0.0f;
        ((MediaEffectKernel3x3Drawer)this.mDrawer).setKernel(this.mLimit, 0.0f);
    }

    public MediaEffectExtraction setParameter(float lowerH, float upperH, float lowerS, float upperS, float lowerV, float upperV, float color_adjust) {
        return this.setParameter(lowerH, upperH, lowerS, upperS, lowerV, upperV, 0.0f, 0.0f, 0.0f, color_adjust);
    }

    public MediaEffectExtraction setParameter(float lowerH, float upperH, float lowerS, float upperS, float lowerV, float upperV, float addH, float addS, float addV, float color_adjust) {
        this.mLimit[0] = Math.min(lowerH, upperH);
        this.mLimit[1] = Math.max(lowerH, upperH);
        this.mLimit[2] = Math.min(lowerS, upperS);
        this.mLimit[3] = Math.max(lowerS, upperS);
        this.mLimit[4] = Math.min(lowerV, upperV);
        this.mLimit[5] = Math.max(lowerV, upperV);
        this.mLimit[6] = addH;
        this.mLimit[7] = addS;
        this.mLimit[8] = addV;
        ((MediaEffectKernel3x3Drawer)this.mDrawer).setKernel(this.mLimit, color_adjust);
        return this;
    }

    public MediaEffectExtraction setParameter(float[] limit, float color_adjust) {
        if (limit == null || limit.length < 6) {
            throw new IllegalArgumentException("limit is null or short");
        }
        System.arraycopy(limit, 0, this.mLimit, 0, 6);
        ((MediaEffectKernel3x3Drawer)this.mDrawer).setKernel(this.mLimit, color_adjust);
        return this;
    }
}

