/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.mediaeffect;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.jiangdg.mediaeffect.MediaEffectDrawer;
import com.jiangdg.mediaeffect.MediaEffectGLESBase;

public class MediaEffectAlphaBlend
extends MediaEffectGLESBase {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaEffectAlphaBlend";
    private static final String FRAGMENT_SHADER_BASE = "#version 100\n%sprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform %s    sTexture2;\nuniform float uMixRate;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a * uMixRate), tex1.a);\n}\n";
    private static final String FRAGMENT_SHADER = String.format("#version 100\n%sprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform %s    sTexture2;\nuniform float uMixRate;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a * uMixRate), tex1.a);\n}\n", "", "sampler2D", "sampler2D");
    private static final String FRAGMENT_SHADER_EXT = String.format("#version 100\n%sprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform %s    sTexture2;\nuniform float uMixRate;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a * uMixRate), tex1.a);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "samplerExternalOES");

    public MediaEffectAlphaBlend() {
        this(0.5f);
    }

    public MediaEffectAlphaBlend(float mixRate) {
        super(new MediaEffectAlphaBlendDrawer(mixRate));
        this.setParameter(mixRate);
    }

    public MediaEffectAlphaBlend setParameter(float mixRate) {
        this.setEnable(true);
        ((MediaEffectAlphaBlendDrawer)this.mDrawer).setMixRate(mixRate);
        return this;
    }

    private static class MediaEffectAlphaBlendDrawer
    extends MediaEffectDrawer {
        private final int muMixRate;
        private float mMixRate;

        protected MediaEffectAlphaBlendDrawer(float initMixRate) {
            this(initMixRate, false);
        }

        protected MediaEffectAlphaBlendDrawer(float initMixRate, boolean isOES) {
            super(2, isOES, isOES ? FRAGMENT_SHADER_EXT : FRAGMENT_SHADER);
            int loc = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"uMixRate");
            if (loc < 0) {
                loc = -1;
            }
            this.muMixRate = loc;
            this.setMixRate(initMixRate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMixRate(float mixRate) {
            Object object = this.mSync;
            synchronized (object) {
                this.mMixRate = mixRate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void preDraw(@NonNull int[] tex_ids, float[] tex_matrix, int offset) {
            super.preDraw(tex_ids, tex_matrix, offset);
            if (this.muMixRate >= 0) {
                Object object = this.mSync;
                synchronized (object) {
                    GLES20.glUniform1f((int)this.muMixRate, (float)this.mMixRate);
                }
            }
        }
    }
}

