/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.jiangdg.media.IMuxer;
import com.jiangdg.media.TimeoutException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;

@TargetApi(value=16)
public final class VideoMuxer
implements IMuxer {
    private static boolean isLoaded = false;
    protected long mNativePtr;
    private volatile boolean mIsStarted;
    private boolean mReleased;
    private int mLastTrackIndex = -1;

    public VideoMuxer(String path) {
        this.mNativePtr = this.nativeCreate(path);
    }

    public VideoMuxer(int fd) {
        this.mNativePtr = this.nativeCreateFromFD(fd);
    }

    @Override
    public void release() {
        if (this.mNativePtr != 0L) {
            this.mReleased = true;
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public int addTrack(@NonNull MediaFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null.");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (format.containsKey("mime")) {
            map.put("mime", format.getString("mime"));
        }
        if (format.containsKey("width")) {
            map.put("width", format.getInteger("width"));
        }
        if (format.containsKey("height")) {
            map.put("height", format.getInteger("height"));
        }
        if (format.containsKey("bitrate")) {
            map.put("bitrate", format.getInteger("bitrate"));
        }
        if (format.containsKey("color-format")) {
            map.put("color-format", format.getInteger("color-format"));
        }
        if (format.containsKey("frame-rate")) {
            map.put("frame-rate", format.getInteger("frame-rate"));
        }
        if (format.containsKey("i-frame-interval")) {
            map.put("i-frame-interval", format.getInteger("i-frame-interval"));
        }
        if (format.containsKey("max-input-size")) {
            map.put("max-input-size", format.getInteger("max-input-size"));
        }
        if (format.containsKey("durationUs")) {
            map.put("durationUs", format.getInteger("durationUs"));
        }
        if (format.containsKey("what")) {
            map.put("what", format.getInteger("what"));
        }
        if (format.containsKey("csd-0")) {
            map.put("csd-0", format.getByteBuffer("csd-0"));
        }
        if (format.containsKey("csd-1")) {
            map.put("csd-1", format.getByteBuffer("csd-1"));
        }
        Object[] ks = map.keySet().toArray();
        int n = ks.length;
        String[] keys = new String[n];
        for (int i = 0; i < n; ++i) {
            keys[i] = (String)ks[i];
        }
        Collection values = map.values();
        int trackIndex = VideoMuxer.nativeAddTrack(this.mNativePtr, keys, values.toArray());
        if (this.mLastTrackIndex >= trackIndex) {
            throw new IllegalArgumentException("Invalid format.");
        }
        this.mLastTrackIndex = trackIndex;
        return trackIndex;
    }

    @Override
    public void start() {
        int res = -1;
        if (this.mNativePtr != 0L) {
            res = VideoMuxer.nativeStart(this.mNativePtr);
        }
        if (res != 0) {
            throw new IllegalStateException("failed to start muxer");
        }
        this.mIsStarted = true;
    }

    @Override
    public void stop() {
        int res;
        this.mIsStarted = false;
        if (this.mNativePtr != 0L && (res = VideoMuxer.nativeStop(this.mNativePtr)) != 0) {
            throw new RuntimeException("failed to stop muxer");
        }
    }

    @Override
    public void writeSampleData(int trackIndex, @NonNull ByteBuffer buf, @NonNull MediaCodec.BufferInfo bufferInfo) {
        int res = 1;
        if (!this.mReleased && this.mNativePtr != 0L) {
            res = VideoMuxer.nativeWriteSampleData(this.mNativePtr, trackIndex, buf, bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs, bufferInfo.flags);
        }
        if (res != 0) {
            switch (res) {
                case -2000: {
                    throw new TimeoutException();
                }
                case 1: {
                    throw new IllegalStateException("muxer already released.");
                }
            }
            throw new IllegalArgumentException("writeSampleData:err=" + res);
        }
    }

    private final native long nativeCreate(String var1);

    private final native long nativeCreateFromFD(int var1);

    private final native void nativeDestroy(long var1);

    private static final native int nativeAddTrack(long var0, String[] var2, Object[] var3);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    private static final native int nativeWriteSampleData(long var0, int var2, ByteBuffer var3, int var4, int var5, long var6, int var8);

    @Override
    public boolean isStarted() {
        return this.mIsStarted && !this.mReleased;
    }

    static {
        if (!isLoaded) {
            System.loadLibrary("c++_shared");
            System.loadLibrary("jpeg-turbo2000");
            System.loadLibrary("png16");
            System.loadLibrary("libuvccommon");
            System.loadLibrary("mediaencoder");
            isLoaded = true;
        }
    }
}

