/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jiangdg.utils.BufferHelper;
import com.jiangdg.utils.BuildCheck;
import com.jiangdg.utils.MediaInfo;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public class MediaCodecHelper {
    private static final String TAG = MediaCodecHelper.class.getSimpleName();
    public static final String MIME_VIDEO_AVC = "video/avc";
    public static final String MIME_AUDIO_AAC = "audio/mp4a-latm";
    @SuppressLint(value={"InlinedApi"})
    public static final int BUFFER_FLAG_KEY_FRAME = BuildCheck.isLollipop() ? 1 : 1;
    public static final byte[] START_MARKER = BufferHelper.ANNEXB_START_MARK;
    public static final int OMX_COLOR_FormatUnused = 0;
    public static final int OMX_COLOR_FormatMonochrome = 1;
    public static final int OMX_COLOR_Format8bitRGB332 = 2;
    public static final int OMX_COLOR_Format12bitRGB444 = 3;
    public static final int OMX_COLOR_Format16bitARGB4444 = 4;
    public static final int OMX_COLOR_Format16bitARGB1555 = 5;
    public static final int OMX_COLOR_Format16bitRGB565 = 6;
    public static final int OMX_COLOR_Format16bitBGR565 = 7;
    public static final int OMX_COLOR_Format18bitRGB666 = 8;
    public static final int OMX_COLOR_Format18bitARGB1665 = 9;
    public static final int OMX_COLOR_Format19bitARGB1666 = 10;
    public static final int OMX_COLOR_Format24bitRGB888 = 11;
    public static final int OMX_COLOR_Format24bitBGR888 = 12;
    public static final int OMX_COLOR_Format24bitARGB1887 = 13;
    public static final int OMX_COLOR_Format25bitARGB1888 = 14;
    public static final int OMX_COLOR_Format32bitBGRA8888 = 15;
    public static final int OMX_COLOR_Format32bitARGB8888 = 16;
    public static final int OMX_COLOR_FormatYUV411Planar = 17;
    public static final int OMX_COLOR_FormatYUV411PackedPlanar = 18;
    public static final int OMX_COLOR_FormatYUV420Planar = 19;
    public static final int OMX_COLOR_FormatYUV420PackedPlanar = 20;
    public static final int OMX_COLOR_FormatYUV420SemiPlanar = 21;
    public static final int OMX_COLOR_FormatYUV422Planar = 22;
    public static final int OMX_COLOR_FormatYUV422PackedPlanar = 23;
    public static final int OMX_COLOR_FormatYUV422SemiPlanar = 24;
    public static final int OMX_COLOR_FormatYCbYCr = 25;
    public static final int OMX_COLOR_FormatYCrYCb = 26;
    public static final int OMX_COLOR_FormatCbYCrY = 27;
    public static final int OMX_COLOR_FormatCrYCbY = 28;
    public static final int OMX_COLOR_FormatYUV444Interleaved = 29;
    public static final int OMX_COLOR_FormatRawBayer8bit = 30;
    public static final int OMX_COLOR_FormatRawBayer10bit = 31;
    public static final int OMX_COLOR_FormatRawBayer8bitcompressed = 32;
    public static final int OMX_COLOR_FormatL2 = 33;
    public static final int OMX_COLOR_FormatL4 = 34;
    public static final int OMX_COLOR_FormatL8 = 35;
    public static final int OMX_COLOR_FormatL16 = 36;
    public static final int OMX_COLOR_FormatL24 = 37;
    public static final int OMX_COLOR_FormatL32 = 38;
    public static final int OMX_COLOR_FormatYUV420PackedSemiPlanar = 39;
    public static final int OMX_COLOR_FormatYUV422PackedSemiPlanar = 40;
    public static final int OMX_COLOR_Format18BitBGR666 = 41;
    public static final int OMX_COLOR_Format24BitARGB6666 = 42;
    public static final int OMX_COLOR_Format24BitABGR6666 = 43;
    public static final int OMX_COLOR_FormatKhronosExtensions = 0x6F000000;
    public static final int OMX_COLOR_FormatVendorStartUnused = 0x7F000000;
    public static final int OMX_COLOR_FormatAndroidOpaque = 2130708361;
    public static final int OMX_TI_COLOR_FormatYUV420PackedSemiPlanar = 2130706688;
    public static final int OMX_QCOM_COLOR_FormatYVU420SemiPlanar = 2141391872;
    public static final int OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    public static final int OMX_SEC_COLOR_FormatNV12Tiled = 2143289346;
    public static final int OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar32m = 2141391876;
    public static final int OMX_COLOR_FormatMax = Integer.MAX_VALUE;
    public static int[] recognizedFormats = new int[]{19, 21, 2141391872};

    @Deprecated
    @Nullable
    public static MediaCodecInfo selectVideoCodec(String mimeType) {
        return MediaCodecHelper.selectVideoEncoder(mimeType);
    }

    @Nullable
    public static MediaCodecInfo selectVideoEncoder(String mimeType) {
        int numCodecs = MediaCodecHelper.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecHelper.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            for (int j = 0; j < n; ++j) {
                int format;
                if (!types[j].equalsIgnoreCase(mimeType) || (format = MediaCodecHelper.selectColorFormat(codecInfo, mimeType)) <= 0) continue;
                return codecInfo;
            }
        }
        return null;
    }

    @NonNull
    public static List<MediaCodecInfo> getVideoEncoderInfos(String mimeType) {
        ArrayList<MediaCodecInfo> result = new ArrayList<MediaCodecInfo>();
        int numCodecs = MediaCodecHelper.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecHelper.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            for (int j = 0; j < n; ++j) {
                int format;
                if (!types[j].equalsIgnoreCase(mimeType) || (format = MediaCodecHelper.selectColorFormat(codecInfo, mimeType)) <= 0) continue;
                result.add(codecInfo);
            }
        }
        return result;
    }

    public static final boolean isRecognizedVideoFormat(int colorFormat) {
        int n = recognizedFormats != null ? recognizedFormats.length : 0;
        for (int i = 0; i < n; ++i) {
            if (recognizedFormats[i] != colorFormat) continue;
            return true;
        }
        return false;
    }

    public static final int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        int result = 0;
        MediaCodecInfo.CodecCapabilities capabilities = MediaCodecHelper.getCodecCapabilities(codecInfo, mimeType);
        for (int colorFormat : capabilities.colorFormats) {
            if (!MediaCodecHelper.isRecognizedVideoFormat(colorFormat)) continue;
            result = colorFormat;
            break;
        }
        return result;
    }

    @Deprecated
    public static final void dumpVideoCodecEncoders() {
        MediaCodecHelper.dumpEncoders();
    }

    public static final void dumpEncoders() {
        int numCodecs = MediaCodecHelper.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecHelper.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                Log.i((String)TAG, (String)("codec:" + codecInfo.getName() + ",MIME:" + types[j]));
                MediaCodecHelper.selectColorFormat(codecInfo, types[j]);
            }
        }
    }

    public static final void dumpDecoders() {
        int numCodecs = MediaCodecHelper.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecHelper.getCodecInfoAt(i);
            if (codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                Log.i((String)TAG, (String)("codec:" + codecInfo.getName() + ",MIME:" + types[j]));
                MediaCodecHelper.selectColorFormat(codecInfo, types[j]);
            }
        }
    }

    public static final boolean isSemiPlanarYUV(int colorFormat) {
        switch (colorFormat) {
            case 19: 
            case 20: {
                return false;
            }
            case 21: 
            case 39: 
            case 2130706688: 
            case 2141391872: {
                return true;
            }
        }
        throw new RuntimeException("unknown format " + colorFormat);
    }

    @Deprecated
    @Nullable
    public static final MediaCodecInfo selectAudioCodec(String mimeType) {
        return MediaCodecHelper.selectAudioEncoder(mimeType);
    }

    @Nullable
    public static final MediaCodecInfo selectAudioEncoder(String mimeType) {
        MediaCodecInfo result = null;
        int numCodecs = MediaCodecHelper.getCodecCount();
        block0: for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecHelper.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                result = codecInfo;
                break block0;
            }
        }
        return result;
    }

    @NonNull
    public static List<MediaCodecInfo> getAudioEncoderInfos(String mimeType) {
        ArrayList<MediaCodecInfo> result = new ArrayList<MediaCodecInfo>();
        int numCodecs = MediaCodecHelper.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecHelper.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                result.add(codecInfo);
            }
        }
        return result;
    }

    public static final int getCodecCount() {
        return MediaInfo.getCodecCount();
    }

    public static final List<MediaCodecInfo> getCodecs() {
        return MediaInfo.getCodecs();
    }

    public static final MediaCodecInfo getCodecInfoAt(int ix) {
        return MediaInfo.getCodecInfoAt(ix);
    }

    public static MediaCodecInfo.CodecCapabilities getCodecCapabilities(MediaCodecInfo codecInfo, String mimeType) {
        return MediaInfo.getCodecCapabilities(codecInfo, mimeType);
    }

    public static boolean checkProfileLevel(String mimeType, MediaCodecInfo info) {
        if (info != null && mimeType.equalsIgnoreCase(MIME_VIDEO_AVC)) {
            MediaCodecInfo.CodecCapabilities caps = MediaCodecHelper.getCodecCapabilities(info, mimeType);
            MediaCodecInfo.CodecProfileLevel[] profileLevel = caps.profileLevels;
            for (int j = 0; j < profileLevel.length; ++j) {
                if (profileLevel[j].level < 16384) continue;
                return false;
            }
        }
        return true;
    }

    public static String getProfileLevelString(String mimeType, MediaCodecInfo.CodecProfileLevel profileLevel) {
        String result = null;
        if (mimeType.equalsIgnoreCase(MIME_VIDEO_AVC)) {
            switch (profileLevel.profile) {
                case 1: {
                    result = "profile:AVCProfileBaseline";
                    break;
                }
                case 2: {
                    result = "profile:AVCProfileMain";
                    break;
                }
                case 4: {
                    result = "profile:AVCProfileExtended";
                    break;
                }
                case 8: {
                    result = "profile:AVCProfileHigh";
                    break;
                }
                case 16: {
                    result = "profile:AVCProfileHigh10";
                    break;
                }
                case 32: {
                    result = "profile:AVCProfileHigh422";
                    break;
                }
                case 64: {
                    result = "profile:AVCProfileHigh444";
                    break;
                }
                default: {
                    result = "profile:unknown " + profileLevel.profile;
                }
            }
            switch (profileLevel.level) {
                case 1: {
                    result = result + ",level=AVCLevel1";
                    break;
                }
                case 2: {
                    result = result + ",level=AVCLevel1b";
                    break;
                }
                case 4: {
                    result = result + ",level=AVCLevel11";
                    break;
                }
                case 8: {
                    result = result + ",level=AVCLevel12";
                    break;
                }
                case 16: {
                    result = result + ",level=AVCLevel13";
                    break;
                }
                case 32: {
                    result = result + ",level=AVCLevel2";
                    break;
                }
                case 64: {
                    result = result + ",level=AVCLevel21";
                    break;
                }
                case 128: {
                    result = result + ",level=AVCLevel22";
                    break;
                }
                case 256: {
                    result = result + ",level=AVCLevel3";
                    break;
                }
                case 512: {
                    result = result + ",level=AVCLevel31";
                    break;
                }
                case 1024: {
                    result = result + ",level=AVCLevel32";
                    break;
                }
                case 2048: {
                    result = result + ",level=AVCLevel4";
                    break;
                }
                case 4096: {
                    result = result + ",level=AVCLevel41";
                    break;
                }
                case 8192: {
                    result = result + ",level=AVCLevel42";
                    break;
                }
                case 16384: {
                    result = result + ",level=AVCLevel5";
                    break;
                }
                case 32768: {
                    result = result + ",level=AVCLevel51";
                    break;
                }
                default: {
                    result = result + ",level=unknown " + profileLevel.level;
                    break;
                }
            }
        } else if (mimeType.equalsIgnoreCase("video/h263")) {
            switch (profileLevel.profile) {
                default: 
            }
            result = "profile:unknown " + profileLevel.profile;
            switch (profileLevel.level) {
                default: 
            }
            result = result + ",level=unknown " + profileLevel.level;
        } else if (mimeType.equalsIgnoreCase("video/mpeg4")) {
            switch (profileLevel.profile) {
                default: 
            }
            result = "profile:unknown " + profileLevel.profile;
            switch (profileLevel.level) {
                default: 
            }
            result = result + ",level=unknown " + profileLevel.level;
        } else if (mimeType.equalsIgnoreCase("audio/aac")) {
            switch (profileLevel.level) {
                default: 
            }
            result = "profile:unknown " + profileLevel.profile;
        } else if (mimeType.equalsIgnoreCase("video/vp8")) {
            switch (profileLevel.profile) {
                default: 
            }
            result = "profile:unknown " + profileLevel.profile;
            switch (profileLevel.level) {
                default: 
            }
            result = result + ",level=unknown " + profileLevel.level;
        }
        return result;
    }

    public static final int findStartMarker(@NonNull byte[] array, int offset) {
        return BufferHelper.byteComp(array, offset, START_MARKER, START_MARKER.length);
    }
}

