/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.media;

import android.content.Context;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.jiangdg.media.IRecorder;
import com.jiangdg.media.Recorder;
import com.jiangdg.media.VideoConfig;
import com.jiangdg.utils.FileUtils;
import com.jiangdg.utils.SAFUtils;
import com.jiangdg.utils.StorageInfo;
import com.jiangdg.utils.UriHelper;
import java.io.IOException;
import java.lang.ref.WeakReference;

public abstract class AbstractMediaAVRecorder
extends Recorder {
    protected final WeakReference<Context> mWeakContext;
    protected final int mSaveTreeId;
    protected String mOutputPath;
    protected DocumentFile mOutputFile;

    public AbstractMediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, String ext, int saveTreeId) throws IOException {
        this(context, callback, null, ext, saveTreeId);
    }

    public AbstractMediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, String prefix, String _ext, int saveTreeId) throws IOException {
        super(callback);
        this.mWeakContext = new WeakReference<Context>(context);
        this.mSaveTreeId = saveTreeId;
        String ext = _ext;
        if (TextUtils.isEmpty((CharSequence)ext)) {
            ext = ".mp4";
        }
        if (saveTreeId > 0 && SAFUtils.hasStorageAccess(context, saveTreeId)) {
            this.mOutputPath = FileUtils.getCaptureFile(context, Environment.DIRECTORY_MOVIES, prefix, ext, saveTreeId).toString();
            String file_name = (TextUtils.isEmpty((CharSequence)prefix) ? FileUtils.getDateTimeString() : prefix + FileUtils.getDateTimeString()) + ext;
            int fd = SAFUtils.createStorageFileFD(context, saveTreeId, "*/*", file_name);
            this.setupMuxer(fd);
        } else {
            try {
                this.mOutputPath = FileUtils.getCaptureFile(context, Environment.DIRECTORY_MOVIES, prefix, ext, 0).toString();
            }
            catch (Exception e) {
                throw new IOException("This app has no permission of writing external storage");
            }
            this.setupMuxer(this.mOutputPath);
        }
    }

    public AbstractMediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, int saveTreeId, @Nullable String dirs, @NonNull String fileName) throws IOException {
        super(callback);
        DocumentFile tree;
        this.mWeakContext = new WeakReference<Context>(context);
        this.mSaveTreeId = saveTreeId;
        if (saveTreeId > 0 && SAFUtils.hasStorageAccess(context, saveTreeId) && (tree = SAFUtils.getStorageFile(context, saveTreeId, dirs, "*/*", fileName)) != null) {
            this.mOutputPath = UriHelper.getPath(context, tree.getUri());
            ParcelFileDescriptor pfd = context.getContentResolver().openFileDescriptor(tree.getUri(), "rw");
            try {
                if (pfd != null) {
                    this.setupMuxer(pfd.getFd());
                    return;
                }
                throw new IOException("could not create ParcelFileDescriptor");
            }
            catch (Exception e) {
                if (pfd != null) {
                    pfd.close();
                }
                throw e;
            }
        }
        throw new IOException("path not found/can't write");
    }

    public AbstractMediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @NonNull DocumentFile output) throws IOException {
        super(callback);
        this.mWeakContext = new WeakReference<Context>(context);
        this.mSaveTreeId = 0;
        this.mOutputFile = output;
        this.mOutputPath = UriHelper.getPath(context, output.getUri());
        this.setupMuxer(context, output);
    }

    public AbstractMediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @NonNull String outputPath) throws IOException {
        super(callback);
        this.mWeakContext = new WeakReference<Context>(context);
        this.mSaveTreeId = 0;
        this.mOutputPath = outputPath;
        if (TextUtils.isEmpty((CharSequence)outputPath)) {
            try {
                this.mOutputPath = FileUtils.getCaptureFile(context, Environment.DIRECTORY_MOVIES, null, ".mp4", 0).toString();
            }
            catch (Exception e) {
                throw new IOException("This app has no permission of writing external storage");
            }
        }
        this.setupMuxer(this.mOutputPath);
    }

    @Override
    @Nullable
    public String getOutputPath() {
        return this.mOutputPath;
    }

    @Override
    @Nullable
    public DocumentFile getOutputFile() {
        return this.mOutputFile;
    }

    @Override
    protected boolean check() {
        StorageInfo info;
        Context context = (Context)this.mWeakContext.get();
        StorageInfo storageInfo = info = this.mOutputFile != null ? SAFUtils.getStorageInfo(context, this.mOutputFile) : null;
        if (info != null && info.totalBytes != 0L) {
            return (float)info.freeBytes / (float)info.totalBytes < FileUtils.FREE_RATIO || (float)info.freeBytes < FileUtils.FREE_SIZE;
        }
        return context == null || this.mOutputFile == null && !FileUtils.checkFreeSpace(context, VideoConfig.maxDuration, this.mStartTime, this.mSaveTreeId);
    }

    @Nullable
    protected Context getContext() {
        return (Context)this.mWeakContext.get();
    }

    protected abstract void setupMuxer(int var1) throws IOException;

    protected abstract void setupMuxer(@NonNull String var1) throws IOException;

    protected abstract void setupMuxer(@NonNull Context var1, @NonNull DocumentFile var2) throws IOException;
}

