/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.io;

import androidx.annotation.NonNull;
import com.jiangdg.io.IWritable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class WritableOutputStreamWrapper
extends OutputStream
implements IWritable {
    private final OutputStream mParent;

    public WritableOutputStreamWrapper(OutputStream parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.mParent = parent;
    }

    @Override
    public void write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        if (len > 0) {
            byte[] buf = new byte[len];
            src.get(buf);
            this.mParent.write(buf, 0, len);
        }
    }

    @Override
    public void write(int val) throws IOException {
        this.mParent.write(val);
    }

    @Override
    public void write(@NonNull byte[] b) throws IOException {
        this.mParent.write(b);
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        this.mParent.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.mParent.flush();
    }

    @Override
    public void close() throws IOException {
        this.mParent.close();
    }
}

