/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.glutils;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import com.jiangdg.glutils.GLHelper;

public class TextureOffscreen {
    private static final boolean DEBUG = false;
    private static final String TAG = "TextureOffscreen";
    private static final boolean DEFAULT_ADJUST_POWER2 = false;
    private final int TEX_TARGET;
    private final int TEX_UNIT;
    private final boolean mHasDepthBuffer;
    private final boolean mAdjustPower2;
    private int mWidth;
    private int mHeight;
    private int mTexWidth;
    private int mTexHeight;
    private int mFBOTextureName = -1;
    private int mDepthBufferObj = -1;
    private int mFrameBufferObj = -1;
    private final float[] mTexMatrix = new float[16];
    private final float[] mResultMatrix = new float[16];

    public TextureOffscreen(int width, int height) {
        this(3553, 33984, -1, width, height, false, false);
    }

    public TextureOffscreen(int tex_unit, int width, int height) {
        this(3553, tex_unit, -1, width, height, false, false);
    }

    public TextureOffscreen(int width, int height, boolean use_depth_buffer) {
        this(3553, 33984, -1, width, height, use_depth_buffer, false);
    }

    public TextureOffscreen(int tex_unit, int width, int height, boolean use_depth_buffer) {
        this(3553, tex_unit, -1, width, height, use_depth_buffer, false);
    }

    public TextureOffscreen(int width, int height, boolean use_depth_buffer, boolean adjust_power2) {
        this(3553, 33984, -1, width, height, use_depth_buffer, adjust_power2);
    }

    public TextureOffscreen(int tex_unit, int width, int height, boolean use_depth_buffer, boolean adjust_power2) {
        this(3553, tex_unit, -1, width, height, use_depth_buffer, adjust_power2);
    }

    public TextureOffscreen(int tex_unit, int tex_id, int width, int height) {
        this(3553, tex_unit, tex_id, width, height, false, false);
    }

    public TextureOffscreen(int tex_unit, int tex_id, int width, int height, boolean use_depth_buffer) {
        this(3553, tex_unit, tex_id, width, height, use_depth_buffer, false);
    }

    public TextureOffscreen(int tex_target, int tex_unit, int tex_id, int width, int height, boolean use_depth_buffer, boolean adjust_power2) {
        this.TEX_TARGET = tex_target;
        this.TEX_UNIT = tex_unit;
        this.mWidth = width;
        this.mHeight = height;
        this.mHasDepthBuffer = use_depth_buffer;
        this.mAdjustPower2 = adjust_power2;
        this.createFrameBuffer(width, height);
        int tex = tex_id;
        if (tex < 0) {
            tex = TextureOffscreen.genTexture(tex_target, tex_unit, this.mTexWidth, this.mTexHeight);
        }
        this.assignTexture(tex, width, height);
    }

    public void release() {
        this.releaseFrameBuffer();
    }

    public void bind() {
        GLES20.glActiveTexture((int)this.TEX_UNIT);
        GLES20.glBindTexture((int)this.TEX_TARGET, (int)this.mFBOTextureName);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferObj);
        GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
    }

    public void unbind() {
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glActiveTexture((int)this.TEX_UNIT);
        GLES20.glBindTexture((int)this.TEX_TARGET, (int)0);
    }

    public float[] getTexMatrix() {
        System.arraycopy(this.mTexMatrix, 0, this.mResultMatrix, 0, 16);
        return this.mResultMatrix;
    }

    public float[] getRawTexMatrix() {
        return this.mTexMatrix;
    }

    public void getTexMatrix(float[] matrix, int offset) {
        System.arraycopy(this.mTexMatrix, 0, matrix, offset, this.mTexMatrix.length);
    }

    public int getTexture() {
        return this.mFBOTextureName;
    }

    public void assignTexture(int texture_name, int width, int height) {
        int status;
        if (width > this.mTexWidth || height > this.mTexHeight) {
            this.mWidth = width;
            this.mHeight = height;
            this.releaseFrameBuffer();
            this.createFrameBuffer(width, height);
        }
        this.mFBOTextureName = texture_name;
        GLES20.glActiveTexture((int)this.TEX_UNIT);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferObj);
        GLHelper.checkGlError("glBindFramebuffer " + this.mFrameBufferObj);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)this.TEX_TARGET, (int)this.mFBOTextureName, (int)0);
        GLHelper.checkGlError("glFramebufferTexture2D");
        if (this.mHasDepthBuffer) {
            GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.mDepthBufferObj);
            GLHelper.checkGlError("glFramebufferRenderbuffer");
        }
        if ((status = GLES20.glCheckFramebufferStatus((int)36160)) != 36053) {
            throw new RuntimeException("Framebuffer not complete, status=" + status);
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
        this.mTexMatrix[0] = (float)width / (float)this.mTexWidth;
        this.mTexMatrix[5] = (float)height / (float)this.mTexHeight;
    }

    public void loadBitmap(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width > this.mTexWidth || height > this.mTexHeight) {
            this.mWidth = width;
            this.mHeight = height;
            this.releaseFrameBuffer();
            this.createFrameBuffer(width, height);
        }
        GLES20.glActiveTexture((int)this.TEX_UNIT);
        GLES20.glBindTexture((int)this.TEX_TARGET, (int)this.mFBOTextureName);
        GLUtils.texImage2D((int)this.TEX_TARGET, (int)0, (Bitmap)bitmap, (int)0);
        GLES20.glBindTexture((int)this.TEX_TARGET, (int)0);
        Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
        this.mTexMatrix[0] = (float)width / (float)this.mTexWidth;
        this.mTexMatrix[5] = (float)height / (float)this.mTexHeight;
    }

    private static int genTexture(int tex_target, int tex_unit, int tex_width, int tex_height) {
        int tex_name = GLHelper.initTex(tex_target, tex_unit, 9729, 9729, 33071);
        GLES20.glTexImage2D((int)tex_target, (int)0, (int)6408, (int)tex_width, (int)tex_height, (int)0, (int)6408, (int)5121, null);
        GLHelper.checkGlError("glTexImage2D");
        return tex_name;
    }

    private final void createFrameBuffer(int width, int height) {
        int[] ids = new int[1];
        if (this.mAdjustPower2) {
            int h;
            int w;
            for (w = 1; w < width; w <<= 1) {
            }
            for (h = 1; h < height; h <<= 1) {
            }
            if (this.mTexWidth != w || this.mTexHeight != h) {
                this.mTexWidth = w;
                this.mTexHeight = h;
            }
        } else {
            this.mTexWidth = width;
            this.mTexHeight = height;
        }
        if (this.mHasDepthBuffer) {
            GLES20.glGenRenderbuffers((int)1, (int[])ids, (int)0);
            this.mDepthBufferObj = ids[0];
            GLES20.glBindRenderbuffer((int)36161, (int)this.mDepthBufferObj);
            GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)this.mTexWidth, (int)this.mTexHeight);
        }
        GLES20.glGenFramebuffers((int)1, (int[])ids, (int)0);
        GLHelper.checkGlError("glGenFramebuffers");
        this.mFrameBufferObj = ids[0];
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferObj);
        GLHelper.checkGlError("glBindFramebuffer " + this.mFrameBufferObj);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    private final void releaseFrameBuffer() {
        int[] names = new int[1];
        if (this.mDepthBufferObj >= 0) {
            names[0] = this.mDepthBufferObj;
            GLES20.glDeleteRenderbuffers((int)1, (int[])names, (int)0);
            this.mDepthBufferObj = -1;
        }
        if (this.mFBOTextureName >= 0) {
            names[0] = this.mFBOTextureName;
            GLES20.glDeleteTextures((int)1, (int[])names, (int)0);
            this.mFBOTextureName = -1;
        }
        if (this.mFrameBufferObj >= 0) {
            names[0] = this.mFrameBufferObj;
            GLES20.glDeleteFramebuffers((int)1, (int[])names, (int)0);
            this.mFrameBufferObj = -1;
        }
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getTexWidth() {
        return this.mTexWidth;
    }

    public int getTexHeight() {
        return this.mTexHeight;
    }

    public int getTexTarget() {
        return this.TEX_TARGET;
    }

    public int getTexUnit() {
        return this.TEX_UNIT;
    }
}

