/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.glutils;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.jiangdg.glutils.GLHelper;
import com.jiangdg.glutils.IDrawer2D;
import com.jiangdg.glutils.IDrawer2dES2;
import com.jiangdg.glutils.ITexture;
import com.jiangdg.glutils.TextureOffscreen;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GLDrawer2D
implements IDrawer2dES2 {
    private static final float[] VERTICES = new float[]{1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    private static final float[] TEXCOORD = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
    private static final int FLOAT_SZ = 4;
    private final int VERTEX_NUM;
    private final int VERTEX_SZ;
    private final FloatBuffer pVertex;
    private final FloatBuffer pTexCoord;
    private final int mTexTarget;
    private int hProgram;
    int maPositionLoc;
    int maTextureCoordLoc;
    int muMVPMatrixLoc;
    int muTexMatrixLoc;
    private final float[] mMvpMatrix = new float[16];

    public GLDrawer2D(boolean isOES) {
        this(VERTICES, TEXCOORD, isOES);
    }

    public GLDrawer2D(float[] vertices, float[] texcoord, boolean isOES) {
        this.VERTEX_NUM = Math.min(vertices != null ? vertices.length : 0, texcoord != null ? texcoord.length : 0) / 2;
        this.VERTEX_SZ = this.VERTEX_NUM * 2;
        this.mTexTarget = isOES ? 36197 : 3553;
        this.pVertex = ByteBuffer.allocateDirect(this.VERTEX_SZ * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.pVertex.put(vertices);
        this.pVertex.flip();
        this.pTexCoord = ByteBuffer.allocateDirect(this.VERTEX_SZ * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.pTexCoord.put(texcoord);
        this.pTexCoord.flip();
        this.hProgram = isOES ? GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}") : GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\nprecision mediump float;\nuniform sampler2D sTexture;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}");
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
        this.init();
    }

    @Override
    public void release() {
        if (this.hProgram >= 0) {
            GLES20.glDeleteProgram((int)this.hProgram);
        }
        this.hProgram = -1;
    }

    public boolean isOES() {
        return this.mTexTarget == 36197;
    }

    @Override
    public float[] getMvpMatrix() {
        return this.mMvpMatrix;
    }

    @Override
    public IDrawer2D setMvpMatrix(float[] matrix, int offset) {
        System.arraycopy(matrix, offset, this.mMvpMatrix, 0, 16);
        return this;
    }

    @Override
    public void getMvpMatrix(float[] matrix, int offset) {
        System.arraycopy(this.mMvpMatrix, 0, matrix, offset, 16);
    }

    @Override
    public synchronized void draw(int texId, float[] tex_matrix, int offset) {
        if (this.hProgram < 0) {
            return;
        }
        GLES20.glUseProgram((int)this.hProgram);
        if (tex_matrix != null) {
            GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])tex_matrix, (int)offset);
        }
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.mTexTarget, (int)texId);
        GLES20.glDrawArrays((int)5, (int)0, (int)this.VERTEX_NUM);
        GLES20.glBindTexture((int)this.mTexTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }

    @Override
    public void draw(ITexture texture) {
        this.draw(texture.getTexture(), texture.getTexMatrix(), 0);
    }

    @Override
    public void draw(TextureOffscreen offscreen) {
        this.draw(offscreen.getTexture(), offscreen.getTexMatrix(), 0);
    }

    public int initTex() {
        return GLHelper.initTex(this.mTexTarget, 9728);
    }

    public void deleteTex(int hTex) {
        GLHelper.deleteTex(hTex);
    }

    public synchronized void updateShader(String vs, String fs) {
        this.release();
        this.hProgram = GLHelper.loadShader(vs, fs);
        this.init();
    }

    public void updateShader(String fs) {
        this.updateShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fs);
    }

    public void resetShader() {
        this.release();
        this.hProgram = this.isOES() ? GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}") : GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\nprecision mediump float;\nuniform sampler2D sTexture;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}");
        this.init();
    }

    @Override
    public int glGetAttribLocation(String name) {
        GLES20.glUseProgram((int)this.hProgram);
        return GLES20.glGetAttribLocation((int)this.hProgram, (String)name);
    }

    @Override
    public int glGetUniformLocation(String name) {
        GLES20.glUseProgram((int)this.hProgram);
        return GLES20.glGetUniformLocation((int)this.hProgram, (String)name);
    }

    @Override
    public void glUseProgram() {
        GLES20.glUseProgram((int)this.hProgram);
    }

    private void init() {
        GLES20.glUseProgram((int)this.hProgram);
        this.maPositionLoc = GLES20.glGetAttribLocation((int)this.hProgram, (String)"aPosition");
        this.maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.hProgram, (String)"aTextureCoord");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.hProgram, (String)"uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.hProgram, (String)"uTexMatrix");
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])this.mMvpMatrix, (int)0);
        GLES20.glVertexAttribPointer((int)this.maPositionLoc, (int)2, (int)5126, (boolean)false, (int)this.VERTEX_SZ, (Buffer)this.pVertex);
        GLES20.glVertexAttribPointer((int)this.maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)this.VERTEX_SZ, (Buffer)this.pTexCoord);
        GLES20.glEnableVertexAttribArray((int)this.maPositionLoc);
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordLoc);
    }
}

