/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.glutils;

import android.annotation.SuppressLint;
import android.opengl.GLES20;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jiangdg.glutils.AbstractRendererHolder;
import com.jiangdg.glutils.EGLBase;
import com.jiangdg.glutils.GLDrawer2D;
import com.jiangdg.glutils.IDrawer2dES2;
import com.jiangdg.glutils.RenderHolderCallback;

public class EffectRendererHolder
extends AbstractRendererHolder {
    private static final String TAG = EffectRendererHolder.class.getSimpleName();
    private static final int MAX_PARAM_NUM = 18;
    public static final int EFFECT_NON = 0;
    public static final int EFFECT_GRAY = 1;
    public static final int EFFECT_GRAY_REVERSE = 2;
    public static final int EFFECT_BIN = 3;
    public static final int EFFECT_BIN_YELLOW = 4;
    public static final int EFFECT_BIN_GREEN = 5;
    public static final int EFFECT_BIN_REVERSE = 6;
    public static final int EFFECT_BIN_REVERSE_YELLOW = 7;
    public static final int EFFECT_BIN_REVERSE_GREEN = 8;
    public static final int EFFECT_EMPHASIZE_RED_YELLOW = 9;
    public static final int EFFECT_EMPHASIZE_RED_YELLOW_WHITE = 10;
    public static final int EFFECT_EMPHASIZE_YELLOW_WHITE = 11;
    public static final int EFFECT_NUM = 12;
    private static final String FRAGMENT_SHADER_GRAY_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 cl3 = vec3(color, color, color);\n    gl_FragColor = vec4(cl3, 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_GRAY_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 cl3 = vec3(color, color, color);\n    gl_FragColor = vec4(cl3, 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private static final String FRAGMENT_SHADER_GRAY_REVERSE_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 cl3 = vec3(color, color, color);\n    gl_FragColor = vec4(clamp(vec3(1.0, 1.0, 1.0) - cl3, 0.0, 1.0), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_GRAY_REVERSE_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 cl3 = vec3(color, color, color);\n    gl_FragColor = vec4(clamp(vec3(1.0, 1.0, 1.0) - cl3, 0.0, 1.0), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private static final String FRAGMENT_SHADER_BIN_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * bin, 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_BIN_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * bin, 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "1.0, 1.0, 1.0");
    private static final String FRAGMENT_SHADER_BIN_YELLOW_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * bin, 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "1.0, 1.0, 0.0");
    private static final String FRAGMENT_SHADER_BIN_GREEN_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * bin, 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "0.0, 1.0, 0.0");
    private static final String FRAGMENT_SHADER_BIN_REVERSE_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * (vec3(1.0, 1.0, 1.0) - bin), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_BIN_REVERSE_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * (vec3(1.0, 1.0, 1.0) - bin), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "1.0, 1.0, 1.0");
    private static final String FRAGMENT_SHADER_BIN_REVERSE_YELLOW_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * (vec3(1.0, 1.0, 1.0) - bin), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "1.0, 1.0, 0.0");
    private static final String FRAGMENT_SHADER_BIN_REVERSE_GREEN_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * (vec3(1.0, 1.0, 1.0) - bin), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "0.0, 1.0, 0.0");
    private static final String FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    if ( ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5]))\n        && ((hsv.r <= uParams[0]) || (hsv.r >= uParams[1])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    if ( ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5]))\n        && ((hsv.r <= uParams[0]) || (hsv.r >= uParams[1])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private static final String FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_WHITE_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    if ( ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5]))\n        && ((hsv.r <= uParams[0]) || (hsv.r >= uParams[1])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else if ((hsv.g < uParams[12]) && (hsv.b < uParams[13])) {\n        hsv = hsv * vec3(1.0, 0.0, 2.0);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_WHITE_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    if ( ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5]))\n        && ((hsv.r <= uParams[0]) || (hsv.r >= uParams[1])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else if ((hsv.g < uParams[12]) && (hsv.b < uParams[13])) {\n        hsv = hsv * vec3(1.0, 0.0, 2.0);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private static final String FRAGMENT_SHADER_EMPHASIZE_YELLOW_WHITE_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 rgb = texture2D(sTexture, vTextureCoord).rgb;\n    vec3 hsv = rgb2hsv(rgb);\n    if (   ((hsv.r >= uParams[0]) && (hsv.r <= uParams[1]))\n        && ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else if ((hsv.g < uParams[12]) && (hsv.b > uParams[13])) {\n        hsv = hsv * vec3(1.0, 0.0, 2.0);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_EMPHASIZE_YELLOW_WHITE_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 rgb = texture2D(sTexture, vTextureCoord).rgb;\n    vec3 hsv = rgb2hsv(rgb);\n    if (   ((hsv.r >= uParams[0]) && (hsv.r <= uParams[1]))\n        && ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else if ((hsv.g < uParams[12]) && (hsv.b > uParams[13])) {\n        hsv = hsv * vec3(1.0, 0.0, 2.0);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private static final int REQUEST_CHANGE_EFFECT = 100;
    private static final int REQUEST_SET_PARAMS = 101;

    public EffectRendererHolder(int width, int height, @Nullable RenderHolderCallback callback) {
        this(width, height, 3, null, 2, callback);
    }

    public EffectRendererHolder(int width, int height, int maxClientVersion, EGLBase.IContext sharedContext, int flags, @Nullable RenderHolderCallback callback) {
        super(width, height, maxClientVersion, sharedContext, flags, callback);
    }

    @Override
    @NonNull
    protected AbstractRendererHolder.RendererTask createRendererTask(int width, int height, int maxClientVersion, EGLBase.IContext sharedContext, int flags) {
        return new MyRendererTask(this, width, height, maxClientVersion, sharedContext, flags);
    }

    public void changeEffect(int effect) {
        ((MyRendererTask)this.mRendererTask).changeEffect(effect);
    }

    public int getCurrentEffect() {
        return ((MyRendererTask)this.mRendererTask).mEffect;
    }

    public void setParams(@NonNull float[] params) {
        ((MyRendererTask)this.mRendererTask).setParams(-1, params);
    }

    public void setParams(int effect, @NonNull float[] params) throws IllegalArgumentException {
        if (effect <= 0) {
            throw new IllegalArgumentException("invalid effect number:" + effect);
        }
        ((MyRendererTask)this.mRendererTask).setParams(effect, params);
    }

    protected void handleDefaultEffect(int effect, @NonNull IDrawer2dES2 drawer) {
        if (drawer instanceof GLDrawer2D) {
            ((GLDrawer2D)drawer).resetShader();
        }
    }

    protected static final class MyRendererTask
    extends AbstractRendererHolder.RendererTask {
        private final SparseArray<float[]> mParams = new SparseArray();
        private int muParamsLoc;
        private float[] mCurrentParams;
        private int mEffect;

        public MyRendererTask(EffectRendererHolder parent, int width, int height) {
            super(parent, width, height);
        }

        public MyRendererTask(@NonNull AbstractRendererHolder parent, int width, int height, int maxClientVersion, EGLBase.IContext sharedContext, int flags) {
            super(parent, width, height, maxClientVersion, sharedContext, flags);
        }

        @Override
        @SuppressLint(value={"NewApi"})
        protected void internalOnStart() {
            super.internalOnStart();
            this.mParams.clear();
            this.mParams.put(9, (Object)new float[]{0.17f, 0.85f, 0.5f, 1.0f, 0.4f, 1.0f, 1.0f, 1.0f, 5.0f, 1.0f, 1.0f, 1.0f});
            this.mParams.put(10, (Object)new float[]{0.17f, 0.85f, 0.5f, 1.0f, 0.4f, 1.0f, 1.0f, 1.0f, 5.0f, 1.0f, 1.0f, 1.0f});
            this.mParams.put(11, (Object)new float[]{0.1f, 0.19f, 0.3f, 1.0f, 0.3f, 1.0f, 1.0f, 1.0f, 5.0f, 1.0f, 0.8f, 0.8f, 0.15f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f});
            this.mEffect = 0;
            this.handleChangeEffect(0);
        }

        @Override
        protected Object processRequest(int request, int arg1, int arg2, Object obj) {
            Object result = null;
            switch (request) {
                case 100: {
                    this.handleChangeEffect(arg1);
                    break;
                }
                case 101: {
                    this.handleSetParam(arg1, (float[])obj);
                    break;
                }
                default: {
                    result = super.processRequest(request, arg1, arg2, obj);
                }
            }
            return result;
        }

        public void changeEffect(int effect) {
            this.checkFinished();
            if (this.mEffect != effect) {
                this.offer(100, effect);
            }
        }

        public void setParams(int effect, @NonNull float[] params) {
            this.checkFinished();
            this.offer(101, effect, 0, params);
        }

        protected void handleChangeEffect(int effect) {
            this.mEffect = effect;
            switch (effect) {
                case 0: {
                    this.mDrawer.updateShader("#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}");
                    break;
                }
                case 1: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_GRAY_OES);
                    break;
                }
                case 2: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_GRAY_REVERSE_OES);
                    break;
                }
                case 3: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_OES);
                    break;
                }
                case 4: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_YELLOW_OES);
                    break;
                }
                case 5: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_GREEN_OES);
                    break;
                }
                case 6: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_REVERSE_OES);
                    break;
                }
                case 7: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_REVERSE_YELLOW_OES);
                    break;
                }
                case 8: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_REVERSE_GREEN_OES);
                    break;
                }
                case 9: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_OES);
                    break;
                }
                case 10: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_WHITE_OES);
                    break;
                }
                case 11: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_EMPHASIZE_YELLOW_WHITE_OES);
                    break;
                }
                default: {
                    try {
                        ((EffectRendererHolder)this.getParent()).handleDefaultEffect(effect, this.mDrawer);
                        break;
                    }
                    catch (Exception e) {
                        this.mDrawer.resetShader();
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
            }
            this.muParamsLoc = this.mDrawer.glGetUniformLocation("uParams");
            this.mCurrentParams = (float[])this.mParams.get(effect);
            this.updateParams();
        }

        private void handleSetParam(int effect, @NonNull float[] params) {
            if (effect < 0 || this.mEffect == effect) {
                this.mCurrentParams = params;
                this.mParams.put(this.mEffect, (Object)params);
                this.updateParams();
            } else {
                this.mParams.put(effect, (Object)params);
            }
        }

        private void updateParams() {
            int n = Math.min(this.mCurrentParams != null ? this.mCurrentParams.length : 0, 18);
            if (this.muParamsLoc >= 0 && n > 0) {
                this.mDrawer.glUseProgram();
                GLES20.glUniform1fv((int)this.muParamsLoc, (int)n, (float[])this.mCurrentParams, (int)0);
            }
        }
    }
}

