/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.glutils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES10;
import android.opengl.GLES20;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.NonNull;
import com.jiangdg.glutils.EGLBase;
import com.jiangdg.utils.BuildCheck;

@TargetApi(value=18)
class EGLBase14
extends EGLBase {
    private static final String TAG = "EGLBase14";
    private static final Context EGL_NO_CONTEXT = new Context(EGL14.EGL_NO_CONTEXT);
    private Config mEglConfig = null;
    @NonNull
    private Context mContext = EGL_NO_CONTEXT;
    private EGLDisplay mEglDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mDefaultContext = EGL14.EGL_NO_CONTEXT;
    private int mGlVersion = 2;
    private final int[] mSurfaceDimension = new int[2];

    public EGLBase14(int maxClientVersion, Context sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        this.init(maxClientVersion, sharedContext, withDepthBuffer, stencilBits, isRecordable);
    }

    @Override
    public void release() {
        if (this.mEglDisplay != EGL14.EGL_NO_DISPLAY) {
            this.destroyContext();
            EGL14.eglTerminate((EGLDisplay)this.mEglDisplay);
            EGL14.eglReleaseThread();
        }
        this.mEglDisplay = EGL14.EGL_NO_DISPLAY;
        this.mContext = EGL_NO_CONTEXT;
    }

    @Override
    public EglSurface createFromSurface(Object nativeWindow) {
        EglSurface eglSurface = new EglSurface(this, nativeWindow);
        eglSurface.makeCurrent();
        return eglSurface;
    }

    @Override
    public EglSurface createOffscreen(int width, int height) {
        EglSurface eglSurface = new EglSurface(this, width, height);
        eglSurface.makeCurrent();
        return eglSurface;
    }

    @Override
    public String queryString(int what) {
        return EGL14.eglQueryString((EGLDisplay)this.mEglDisplay, (int)what);
    }

    @Override
    public int getGlVersion() {
        return this.mGlVersion;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Config getConfig() {
        return this.mEglConfig;
    }

    @Override
    public void makeDefault() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
            Log.w((String)"TAG", (String)("makeDefault" + EGL14.eglGetError()));
        }
    }

    @Override
    public void sync() {
        EGL14.eglWaitGL();
        EGL14.eglWaitNative((int)12379);
    }

    private void init(int maxClientVersion, Context sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        EGLContext context;
        EGLConfig config;
        block12: {
            if (this.mEglDisplay != EGL14.EGL_NO_DISPLAY) {
                throw new RuntimeException("EGL already set up");
            }
            this.mEglDisplay = EGL14.eglGetDisplay((int)0);
            if (this.mEglDisplay == EGL14.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] version = new int[2];
            if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
                this.mEglDisplay = null;
                throw new RuntimeException("eglInitialize failed");
            }
            Context context2 = sharedContext = sharedContext != null ? sharedContext : EGL_NO_CONTEXT;
            if (maxClientVersion >= 3 && (config = this.getConfig(3, withDepthBuffer, stencilBits, isRecordable)) != null) {
                context = this.createContext(sharedContext, config, 3);
                if (EGL14.eglGetError() == 12288) {
                    this.mEglConfig = new Config(config);
                    this.mContext = new Context(context);
                    this.mGlVersion = 3;
                }
            }
            if (maxClientVersion >= 2 && (this.mContext == null || this.mContext.eglContext == EGL14.EGL_NO_CONTEXT)) {
                config = this.getConfig(2, withDepthBuffer, stencilBits, isRecordable);
                if (config == null) {
                    throw new RuntimeException("chooseConfig failed");
                }
                try {
                    context = this.createContext(sharedContext, config, 2);
                    this.checkEglError("eglCreateContext");
                    this.mEglConfig = new Config(config);
                    this.mContext = new Context(context);
                    this.mGlVersion = 2;
                }
                catch (Exception e) {
                    if (!isRecordable) break block12;
                    config = this.getConfig(2, withDepthBuffer, stencilBits, false);
                    if (config == null) {
                        throw new RuntimeException("chooseConfig failed");
                    }
                    EGLContext context3 = this.createContext(sharedContext, config, 2);
                    this.checkEglError("eglCreateContext");
                    this.mEglConfig = new Config(config);
                    this.mContext = new Context(context3);
                    this.mGlVersion = 2;
                }
            }
        }
        if (this.mContext == null || this.mContext.eglContext == EGL14.EGL_NO_CONTEXT) {
            config = this.getConfig(1, withDepthBuffer, stencilBits, isRecordable);
            if (config == null) {
                throw new RuntimeException("chooseConfig failed");
            }
            context = this.createContext(sharedContext, config, 1);
            this.checkEglError("eglCreateContext");
            this.mEglConfig = new Config(config);
            this.mContext = new Context(context);
            this.mGlVersion = 1;
        }
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mContext.eglContext, (int)12440, (int[])values, (int)0);
        Log.d((String)TAG, (String)("EGLContext created, client version " + values[0]));
        this.makeDefault();
    }

    private boolean makeCurrent(EGLSurface surface) {
        if (surface == null || surface == EGL14.EGL_NO_SURFACE) {
            int error = EGL14.eglGetError();
            if (error == 12299) {
                Log.e((String)TAG, (String)"makeCurrent:returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)surface, (EGLSurface)surface, (EGLContext)this.mContext.eglContext)) {
            Log.w((String)"TAG", (String)("eglMakeCurrent" + EGL14.eglGetError()));
            return false;
        }
        return true;
    }

    private int swap(EGLSurface surface) {
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)surface)) {
            int err = EGL14.eglGetError();
            return err;
        }
        return 12288;
    }

    private int swap(EGLSurface surface, long presentationTimeNs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)surface, (long)presentationTimeNs);
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)surface)) {
            int err = EGL14.eglGetError();
            return err;
        }
        return 12288;
    }

    private EGLContext createContext(Context sharedContext, EGLConfig config, int version) {
        int[] attrib_list = new int[]{12440, version, 12344};
        EGLContext context = EGL14.eglCreateContext((EGLDisplay)this.mEglDisplay, (EGLConfig)config, (EGLContext)sharedContext.eglContext, (int[])attrib_list, (int)0);
        return context;
    }

    private void destroyContext() {
        if (!EGL14.eglDestroyContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mContext.eglContext)) {
            Log.e((String)"destroyContext", (String)("display:" + this.mEglDisplay + " context: " + this.mContext.eglContext));
            Log.e((String)TAG, (String)("eglDestroyContext:" + EGL14.eglGetError()));
        }
        this.mContext = EGL_NO_CONTEXT;
        if (this.mDefaultContext != EGL14.EGL_NO_CONTEXT) {
            if (!EGL14.eglDestroyContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mDefaultContext)) {
                Log.e((String)"destroyContext", (String)("display:" + this.mEglDisplay + " context: " + this.mDefaultContext));
                Log.e((String)TAG, (String)("eglDestroyContext:" + EGL14.eglGetError()));
            }
            this.mDefaultContext = EGL14.EGL_NO_CONTEXT;
        }
    }

    private final int getSurfaceWidth(EGLSurface surface) {
        boolean ret = EGL14.eglQuerySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)surface, (int)12375, (int[])this.mSurfaceDimension, (int)0);
        if (!ret) {
            this.mSurfaceDimension[0] = 0;
        }
        return this.mSurfaceDimension[0];
    }

    private final int getSurfaceHeight(EGLSurface surface) {
        boolean ret = EGL14.eglQuerySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)surface, (int)12374, (int[])this.mSurfaceDimension, (int)1);
        if (!ret) {
            this.mSurfaceDimension[1] = 0;
        }
        return this.mSurfaceDimension[1];
    }

    private final EGLSurface createWindowSurface(Object nativeWindow) {
        int[] surfaceAttribs = new int[]{12344};
        EGLSurface result = null;
        try {
            result = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEglDisplay, (EGLConfig)this.mEglConfig.eglConfig, (Object)nativeWindow, (int[])surfaceAttribs, (int)0);
            if (result == null || result == EGL14.EGL_NO_SURFACE) {
                int error = EGL14.eglGetError();
                if (error == 12299) {
                    Log.e((String)TAG, (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                throw new RuntimeException("createWindowSurface failed error=" + error);
            }
            this.makeCurrent(result);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"eglCreateWindowSurface", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    private final EGLSurface createOffscreenSurface(int width, int height) {
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        EGLSurface result = null;
        try {
            result = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEglDisplay, (EGLConfig)this.mEglConfig.eglConfig, (int[])surfaceAttribs, (int)0);
            this.checkEglError("eglCreatePbufferSurface");
            if (result == null) {
                throw new RuntimeException("surface was null");
            }
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"createOffscreenSurface", (Throwable)e);
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"createOffscreenSurface", (Throwable)e);
        }
        return result;
    }

    private void destroyWindowSurface(EGLSurface surface) {
        if (surface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)surface);
        }
        surface = EGL14.EGL_NO_SURFACE;
    }

    private void checkEglError(String msg) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }

    private EGLConfig getConfig(int version, boolean hasDepthBuffer, int stencilBits, boolean isRecordable) {
        int renderableType = 4;
        if (version >= 3) {
            renderableType |= 0x40;
        }
        int[] attribList = new int[]{12352, renderableType, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344, 12344, 12344, 12344, 12344, 12344, 12344};
        int offset = 10;
        if (stencilBits > 0) {
            attribList[offset++] = 12326;
            attribList[offset++] = stencilBits;
        }
        if (hasDepthBuffer) {
            attribList[offset++] = 12325;
            attribList[offset++] = 16;
        }
        if (isRecordable && BuildCheck.isAndroid4_3()) {
            attribList[offset++] = 12610;
            attribList[offset++] = 1;
        }
        for (int i = attribList.length - 1; i >= offset; --i) {
            attribList[i] = 12344;
        }
        EGLConfig config = this.internalGetConfig(attribList);
        if (config == null && version == 2 && isRecordable) {
            int n = attribList.length;
            for (int i = 10; i < n - 1; i += 2) {
                if (attribList[i] != 12610) continue;
                for (int j = i; j < n; ++j) {
                    attribList[j] = 12344;
                }
                break;
            }
            config = this.internalGetConfig(attribList);
        }
        if (config == null) {
            Log.w((String)TAG, (String)"try to fallback to RGB565");
            attribList[3] = 5;
            attribList[5] = 6;
            attribList[7] = 5;
            config = this.internalGetConfig(attribList);
        }
        return config;
    }

    private EGLConfig internalGetConfig(int[] attribList) {
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEglDisplay, (int[])attribList, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0)) {
            return null;
        }
        return configs[0];
    }

    public static class EglSurface
    implements EGLBase.IEglSurface {
        private final EGLBase14 mEglBase;
        private EGLSurface mEglSurface = EGL14.EGL_NO_SURFACE;

        private EglSurface(EGLBase14 eglBase, Object surface) throws IllegalArgumentException {
            this.mEglBase = eglBase;
            if (!(surface instanceof Surface || surface instanceof SurfaceHolder || surface instanceof SurfaceTexture || surface instanceof SurfaceView)) {
                throw new IllegalArgumentException("unsupported surface");
            }
            this.mEglSurface = this.mEglBase.createWindowSurface(surface);
        }

        private EglSurface(EGLBase14 eglBase, int width, int height) {
            this.mEglBase = eglBase;
            this.mEglSurface = width <= 0 || height <= 0 ? this.mEglBase.createOffscreenSurface(1, 1) : this.mEglBase.createOffscreenSurface(width, height);
        }

        @Override
        public void makeCurrent() {
            this.mEglBase.makeCurrent(this.mEglSurface);
            if (this.mEglBase.getGlVersion() >= 2) {
                GLES20.glViewport((int)0, (int)0, (int)this.mEglBase.getSurfaceWidth(this.mEglSurface), (int)this.mEglBase.getSurfaceHeight(this.mEglSurface));
            } else {
                GLES10.glViewport((int)0, (int)0, (int)this.mEglBase.getSurfaceWidth(this.mEglSurface), (int)this.mEglBase.getSurfaceHeight(this.mEglSurface));
            }
        }

        @Override
        public void swap() {
            this.mEglBase.swap(this.mEglSurface);
        }

        @Override
        public void swap(long presentationTimeNs) {
            this.mEglBase.swap(this.mEglSurface, presentationTimeNs);
        }

        public void setPresentationTime(long presentationTimeNs) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglBase.mEglDisplay, (EGLSurface)this.mEglSurface, (long)presentationTimeNs);
        }

        @Override
        public EGLBase.IContext getContext() {
            return this.mEglBase.getContext();
        }

        @Override
        public boolean isValid() {
            return this.mEglSurface != null && this.mEglSurface != EGL14.EGL_NO_SURFACE && this.mEglBase.getSurfaceWidth(this.mEglSurface) > 0 && this.mEglBase.getSurfaceHeight(this.mEglSurface) > 0;
        }

        @Override
        public void release() {
            this.mEglBase.makeDefault();
            this.mEglBase.destroyWindowSurface(this.mEglSurface);
            this.mEglSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    public static class Config
    extends EGLBase.IConfig {
        public final EGLConfig eglConfig;

        private Config(EGLConfig eglConfig) {
            this.eglConfig = eglConfig;
        }
    }

    public static class Context
    extends EGLBase.IContext {
        public final EGLContext eglContext;

        private Context(EGLContext context) {
            this.eglContext = context;
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public long getNativeHandle() {
            return this.eglContext != null ? (BuildCheck.isLollipop() ? this.eglContext.getNativeHandle() : (long)this.eglContext.getHandle()) : 0L;
        }

        @Override
        public Object getEGLContext() {
            return this.eglContext;
        }
    }
}

