/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.glutils;

import android.os.Build;
import com.jiangdg.glutils.EGLBase10;
import com.jiangdg.glutils.EGLBase14;

public abstract class EGLBase {
    public static final Object EGL_LOCK = new Object();
    public static final int EGL_RECORDABLE_ANDROID = 12610;
    public static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    public static final int EGL_OPENGL_ES2_BIT = 4;
    public static final int EGL_OPENGL_ES3_BIT_KHR = 64;

    public static EGLBase createFrom(IContext sharedContext, boolean withDepthBuffer, boolean isRecordable) {
        return EGLBase.createFrom(3, sharedContext, withDepthBuffer, 0, isRecordable);
    }

    public static EGLBase createFrom(IContext sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        return EGLBase.createFrom(3, sharedContext, withDepthBuffer, stencilBits, isRecordable);
    }

    public static EGLBase createFrom(int maxClientVersion, IContext sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        if (EGLBase.isEGL14Supported() && (sharedContext == null || sharedContext instanceof EGLBase14.Context)) {
            return new EGLBase14(maxClientVersion, (EGLBase14.Context)sharedContext, withDepthBuffer, stencilBits, isRecordable);
        }
        return new EGLBase10(maxClientVersion, (EGLBase10.Context)sharedContext, withDepthBuffer, stencilBits, isRecordable);
    }

    public static boolean isEGL14Supported() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public abstract void release();

    public abstract String queryString(int var1);

    public abstract int getGlVersion();

    public abstract IContext getContext();

    public abstract IConfig getConfig();

    public abstract IEglSurface createFromSurface(Object var1);

    public abstract IEglSurface createOffscreen(int var1, int var2);

    public abstract void makeDefault();

    public abstract void sync();

    public static interface IEglSurface {
        public void makeCurrent();

        public void swap();

        public IContext getContext();

        public void swap(long var1);

        public void release();

        public boolean isValid();
    }

    public static abstract class IConfig {
    }

    public static abstract class IContext {
        public abstract long getNativeHandle();

        public abstract Object getEGLContext();
    }
}

