/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.glutils;

import android.graphics.SurfaceTexture;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.jiangdg.glutils.EGLBase;
import com.jiangdg.glutils.EglTask;
import com.jiangdg.glutils.IRenderer;
import com.jiangdg.utils.MessageTask;

public class DumbRenderer
implements IRenderer {
    private static final String TAG = DumbRenderer.class.getSimpleName();
    private final Object mSync = new Object();
    private RendererTask mRendererTask;
    private int mMirror = 0;
    private static final int REQUEST_SET_SURFACE = 1;
    private static final int REQUEST_DRAW = 2;
    private static final int REQUEST_RESIZE = 3;
    private static final int REQUEST_MIRROR = 4;

    public DumbRenderer(EGLBase.IContext sharedContext, int flags, RendererDelegater delegater) {
        this(3, sharedContext, flags, delegater);
    }

    public DumbRenderer(int maxClientVersion, EGLBase.IContext sharedContext, int flags, RendererDelegater delegater) {
        this.mRendererTask = new RendererTask(maxClientVersion, sharedContext, flags, delegater);
        new Thread((Runnable)this.mRendererTask, TAG).start();
        if (!this.mRendererTask.waitReady()) {
            throw new RuntimeException("failed to start renderer thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRendererTask != null) {
                this.mRendererTask.release();
                this.mRendererTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSurface(Surface surface) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRendererTask != null) {
                this.mRendererTask.offer(1, surface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSurface(SurfaceTexture surface) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRendererTask != null) {
                this.mRendererTask.offer(1, surface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMirror(int mirror) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mMirror != mirror) {
                this.mMirror = mirror;
                if (this.mRendererTask != null) {
                    this.mRendererTask.offer(4, mirror % 4);
                }
            }
        }
    }

    @Override
    public int getMirror() {
        return this.mMirror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int width, int height) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRendererTask != null) {
                this.mRendererTask.offer(3, width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestRender(Object ... args) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRendererTask != null) {
                this.mRendererTask.offer(2, args);
            }
        }
    }

    private static class RendererTask
    extends EglTask {
        private final RendererDelegater mDelegater;
        private int frameWidth;
        private int frameHeight;
        private int frameRotation;
        private int surfaceWidth;
        private int surfaceHeight;
        private boolean mirror;

        public RendererTask(EGLBase.IContext sharedContext, int flags, @NonNull RendererDelegater delegater) {
            this(3, sharedContext, flags, delegater);
        }

        public RendererTask(int maxClientVersion, EGLBase.IContext sharedContext, int flags, @NonNull RendererDelegater delegater) {
            super(maxClientVersion, sharedContext, flags);
            this.mDelegater = delegater;
        }

        @Override
        protected void onStart() {
            this.makeCurrent();
            try {
                this.mDelegater.onStart(this.getEgl());
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }

        @Override
        protected void onStop() {
            this.makeCurrent();
            try {
                this.mDelegater.onStop(this.getEgl());
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }

        @Override
        protected Object processRequest(int request, int arg1, int arg2, Object obj) throws MessageTask.TaskBreak {
            switch (request) {
                case 1: {
                    this.handleSetSurface(obj);
                    break;
                }
                case 2: {
                    this.handleDraw(obj);
                    break;
                }
                case 3: {
                    this.handleResize(arg1, arg2);
                    break;
                }
                case 4: {
                    this.handleMirror(arg1);
                }
            }
            return null;
        }

        private void handleSetSurface(Object surface) {
            this.makeCurrent();
            try {
                this.mDelegater.onSetSurface(this.getEgl(), surface);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }

        private void handleResize(int width, int height) {
            if (this.surfaceWidth != width || this.surfaceHeight != height) {
                this.surfaceWidth = width;
                this.surfaceHeight = height;
                this.makeCurrent();
                try {
                    this.mDelegater.onResize(this.getEgl(), width, height);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.handleDraw(new Object[0]);
            }
        }

        private void handleDraw(Object ... args) {
            this.makeCurrent();
            try {
                this.mDelegater.onDraw(this.getEgl(), args);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }

        private void handleMirror(int mirror) {
            this.makeCurrent();
            try {
                this.mDelegater.onMirror(this.getEgl(), mirror);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public static interface RendererDelegater {
        public void onStart(EGLBase var1);

        public void onStop(EGLBase var1);

        public void onSetSurface(EGLBase var1, Object var2);

        public void onResize(EGLBase var1, int var2, int var3);

        public void onDraw(EGLBase var1, Object ... var2);

        public void onMirror(EGLBase var1, int var2);
    }
}

