/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.dialog;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.jiangdg.dialog.DialogFragmentEx;
import com.jiangdg.utils.BuildCheck;

public class MessageDialogFragmentV4
extends DialogFragmentEx {
    private static final String TAG = MessageDialogFragmentV4.class.getSimpleName();
    private static final String ARGS_KEY_PERMISSIONS = "permissions";
    private MessageDialogListener mDialogListener;
    private final DialogInterface.OnClickListener mOnClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            MessageDialogFragmentV4.this.callOnMessageDialogResult(which == -1);
        }
    };

    public static MessageDialogFragmentV4 showDialog(@NonNull FragmentActivity parent, int requestCode, @StringRes int id_title, @StringRes int id_message, @NonNull String[] permissions) throws IllegalStateException {
        MessageDialogFragmentV4 dialog = MessageDialogFragmentV4.newInstance(requestCode, id_title, id_message, permissions);
        dialog.show(parent.getSupportFragmentManager(), TAG);
        return dialog;
    }

    public static MessageDialogFragmentV4 showDialog(@NonNull Fragment parent, int requestCode, @StringRes int id_title, @StringRes int id_message, @NonNull String[] permissions) throws IllegalStateException {
        MessageDialogFragmentV4 dialog = MessageDialogFragmentV4.newInstance(requestCode, id_title, id_message, permissions);
        dialog.setTargetFragment(parent, parent.getId());
        dialog.show(parent.requireFragmentManager(), TAG);
        return dialog;
    }

    public static MessageDialogFragmentV4 newInstance(int requestCode, @StringRes int id_title, @StringRes int id_message, @NonNull String[] permissions) {
        MessageDialogFragmentV4 fragment = new MessageDialogFragmentV4();
        Bundle args = new Bundle();
        args.putInt("requestCode", requestCode);
        args.putInt("title", id_title);
        args.putInt("message", id_message);
        args.putStringArray(ARGS_KEY_PERMISSIONS, permissions);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        Fragment target;
        Fragment fragment;
        super.onAttach(context);
        if (context instanceof MessageDialogListener) {
            this.mDialogListener = (MessageDialogListener)context;
        }
        if (this.mDialogListener == null && (fragment = this.getTargetFragment()) instanceof MessageDialogListener) {
            this.mDialogListener = (MessageDialogListener)fragment;
        }
        if (this.mDialogListener == null && BuildCheck.isAndroid4_2() && (target = this.getParentFragment()) instanceof MessageDialogListener) {
            this.mDialogListener = (MessageDialogListener)target;
        }
        if (this.mDialogListener == null) {
            throw new ClassCastException(context.toString());
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = savedInstanceState != null ? savedInstanceState : this.requireArguments();
        int id_title = args.getInt("title");
        int id_message = args.getInt("message");
        FragmentActivity activity = this.requireActivity();
        return new AlertDialog.Builder((Context)activity).setIcon(17301543).setTitle(id_title).setMessage(id_message).setPositiveButton(17039370, this.mOnClickListener).setNegativeButton(0x1040000, this.mOnClickListener).create();
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.callOnMessageDialogResult(false);
    }

    private void callOnMessageDialogResult(boolean result) throws IllegalStateException {
        Bundle args = this.requireArguments();
        int requestCode = args.getInt("requestCode");
        String[] permissions = args.getStringArray(ARGS_KEY_PERMISSIONS);
        try {
            this.mDialogListener.onMessageDialogResult(this, requestCode, permissions, result);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    public static interface MessageDialogListener {
        public void onMessageDialogResult(@NonNull MessageDialogFragmentV4 var1, int var2, @NonNull String[] var3, boolean var4);
    }
}

