/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.bluetooth;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.jiangdg.bluetooth.BluetoothDeviceInfo;
import com.jiangdg.utils.HandlerThreadHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;

@SuppressLint(value={"MissingPermission"})
public class BluetoothManager {
    private static final String TAG = BluetoothManager.class.getSimpleName();
    public static final UUID UUID_SPP = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    public static final int STATE_RELEASED = -1;
    public static final int STATE_NONE = 0;
    public static final int STATE_LISTEN = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_CONNECTED = 3;
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final WeakReference<Context> mWeakContext;
    private final Set<BluetoothManagerCallback> mCallbacks = new CopyOnWriteArraySet<BluetoothManagerCallback>();
    @NonNull
    private final UUID mSecureProfileUUID;
    @NonNull
    private final UUID mInSecureProfileUUID;
    @NonNull
    private final BluetoothAdapter mAdapter;
    private final String mName;
    private volatile int mState;
    private ListeningThread mSecureListeningThread;
    private ListeningThread mInSecureListeningThread;
    private ConnectingThread mConnectingThread;
    private ReceiverThread mReceiverThread;
    private Handler mAsyncHandler;
    private final List<BluetoothDeviceInfo> mDiscoveredDeviceList = new ArrayList<BluetoothDeviceInfo>();
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action;
            String string = action = intent != null ? intent.getAction() : null;
            if ("android.bluetooth.device.action.FOUND".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (device.getBondState() != 12) {
                    List list = BluetoothManager.this.mDiscoveredDeviceList;
                    synchronized (list) {
                        BluetoothManager.this.mDiscoveredDeviceList.add(new BluetoothDeviceInfo(device));
                    }
                    BluetoothManager.this.callOnDiscover();
                }
            } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                BluetoothManager.this.callOnDiscover();
            }
        }
    };

    public static boolean isAvailable() {
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            return adapter != null;
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return false;
        }
    }

    public static boolean isEnabled() {
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            return adapter != null && adapter.isEnabled();
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            return false;
        }
    }

    public static boolean requestBluetoothEnable(@NonNull Activity activity, int requestCode) throws SecurityException {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && !adapter.isEnabled()) {
            Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            activity.startActivityForResult(intent, requestCode);
        }
        return adapter != null && adapter.isEnabled();
    }

    public static boolean requestBluetoothEnable(@NonNull Fragment fragment, int requestCode) throws SecurityException {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && !adapter.isEnabled()) {
            Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            fragment.startActivityForResult(intent, requestCode);
        }
        return adapter != null && adapter.isEnabled();
    }

    public static boolean requestBluetoothEnable(@NonNull androidx.fragment.app.Fragment fragment, int requestCode) throws SecurityException {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && !adapter.isEnabled()) {
            Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            fragment.startActivityForResult(intent, requestCode);
        }
        return adapter != null && adapter.isEnabled();
    }

    @Nullable
    public static Set<BluetoothDevice> getBondedDevices() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.isEnabled()) {
            return adapter.getBondedDevices();
        }
        return null;
    }

    public static boolean requestDiscoverable(@NonNull Activity activity, int duration) throws IllegalStateException {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || !adapter.isEnabled()) {
            throw new IllegalStateException("bluetooth\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u304b\u7121\u52b9\u306b\u306a\u3063\u3066\u3044\u308b");
        }
        if (adapter.getScanMode() != 23) {
            Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
            intent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", duration);
            activity.startActivity(intent);
        }
        return adapter.getScanMode() == 23;
    }

    public static boolean requestDiscoverable(@NonNull Fragment fragment, int duration) throws IllegalStateException {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || !adapter.isEnabled()) {
            throw new IllegalStateException("bluetooth\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u304b\u7121\u52b9\u306b\u306a\u3063\u3066\u3044\u308b");
        }
        if (adapter.getScanMode() != 23) {
            Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
            if (duration > 0 && duration <= 300) {
                intent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", duration);
            }
            fragment.startActivity(intent);
        }
        return adapter.getScanMode() == 23;
    }

    public BluetoothManager(@NonNull Context context, String name, @NonNull UUID secureProfileUUID, @NonNull BluetoothManagerCallback callback) {
        this(context, name, secureProfileUUID, null, callback);
    }

    public BluetoothManager(@NonNull Context context, String name, @NonNull UUID secureProfileUUID, @Nullable UUID inSecureProfileUUID, @NonNull BluetoothManagerCallback callback) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mName = !TextUtils.isEmpty((CharSequence)name) ? name : Build.MODEL + "_" + Build.ID;
        this.mSecureProfileUUID = secureProfileUUID;
        UUID uUID = this.mInSecureProfileUUID = inSecureProfileUUID != null ? inSecureProfileUUID : secureProfileUUID;
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mAdapter == null || !this.mAdapter.isEnabled()) {
            throw new IllegalStateException("bluetooth\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u304b\u7121\u52b9\u306b\u306a\u3063\u3066\u3044\u308b");
        }
        this.mState = 0;
        this.mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        context.registerReceiver(this.mBroadcastReceiver, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.mCallbacks.clear();
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != -1) {
                this.mState = -1;
                this.stop();
                if (this.mAsyncHandler != null) {
                    try {
                        this.mAsyncHandler.getLooper().quit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mAsyncHandler = null;
                }
                try {
                    this.getContext().unregisterReceiver(this.mBroadcastReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void addCallback(BluetoothManagerCallback callback) {
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
    }

    public void removeCallback(BluetoothManagerCallback callback) {
        this.mCallbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BluetoothDeviceInfo> getPairedDevices() {
        this.checkReleased();
        ArrayList<BluetoothDeviceInfo> result = new ArrayList<BluetoothDeviceInfo>();
        Object object = this.mSync;
        synchronized (object) {
            Set pairedDevices;
            if (this.mAdapter.isDiscovering()) {
                this.mAdapter.cancelDiscovery();
            }
            if ((pairedDevices = this.mAdapter.getBondedDevices()).size() > 0) {
                for (BluetoothDevice device : pairedDevices) {
                    result.add(new BluetoothDeviceInfo(device));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDiscovery() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAdapter.isDiscovering()) {
                this.mAdapter.cancelDiscovery();
            }
            Set pairedDevices = this.mAdapter.getBondedDevices();
            List<BluetoothDeviceInfo> list = this.mDiscoveredDeviceList;
            synchronized (list) {
                this.mDiscoveredDeviceList.clear();
                if (pairedDevices.size() > 0) {
                    for (BluetoothDevice device : pairedDevices) {
                        this.mDiscoveredDeviceList.add(new BluetoothDeviceInfo(device));
                    }
                    this.callOnDiscover();
                }
            }
            this.mAdapter.startDiscovery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDiscovery() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAdapter.isDiscovering()) {
                this.mAdapter.cancelDiscovery();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListen() {
        Object object = this.mSync;
        synchronized (object) {
            this.checkReleased();
            this.internalStartListen();
        }
    }

    public void connect(BluetoothDeviceInfo info) throws IllegalStateException {
        this.checkReleased();
        this.connect(this.mAdapter.getRemoteDevice(info.address));
    }

    public void connect(String macAddress) throws IllegalArgumentException, IllegalStateException {
        this.checkReleased();
        this.connect(this.mAdapter.getRemoteDevice(macAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(BluetoothDevice device) throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            this.checkReleased();
            this.internalCancel(2, false);
            try {
                this.mConnectingThread = new ConnectingThread(device, true);
            }
            catch (IOException e) {
                try {
                    this.mConnectingThread = new ConnectingThread(device, false);
                }
                catch (IOException e1) {
                    throw new IllegalStateException(e1);
                }
            }
            this.mConnectingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            this.internalCancel(0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] message) throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            this.checkReleased();
            if (this.mReceiverThread != null) {
                this.mReceiverThread.write(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] message, int offset, int len) throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            this.checkReleased();
            if (this.mReceiverThread != null) {
                this.mReceiverThread.write(message, offset, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReleased() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mState == -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mState == 1;
        }
    }

    protected Context getContext() {
        return (Context)this.mWeakContext.get();
    }

    private void checkReleased() throws IllegalStateException {
        if (this.mState == -1) {
            throw new IllegalStateException("already released");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStartListen() {
        Object object = this.mSync;
        synchronized (object) {
            this.internalCancel(1, false);
            if (this.isReleased()) {
                return;
            }
            if (this.mSecureListeningThread == null) {
                this.mSecureListeningThread = new ListeningThread(true);
                this.mSecureListeningThread.start();
            }
            if (this.mInSecureListeningThread == null) {
                this.mInSecureListeningThread = new ListeningThread(false);
                this.mInSecureListeningThread.start();
            }
        }
    }

    private void internalCancel(int newState, boolean cancelListening) {
        if (this.mAdapter.isDiscovering()) {
            this.mAdapter.cancelDiscovery();
        }
        if (this.mConnectingThread != null) {
            this.mConnectingThread.cancel();
            this.mConnectingThread = null;
        }
        if (this.mReceiverThread != null) {
            this.mReceiverThread.cancel();
            this.mReceiverThread = null;
        }
        if (this.mState == -1 || cancelListening) {
            if (this.mSecureListeningThread != null) {
                this.mSecureListeningThread.cancel();
                this.mSecureListeningThread = null;
            }
            if (this.mInSecureListeningThread != null) {
                this.mInSecureListeningThread.cancel();
                this.mInSecureListeningThread = null;
            }
        }
        this.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callOnDiscover() {
        ArrayList<BluetoothDeviceInfo> devices;
        Object object = this.mDiscoveredDeviceList;
        synchronized (object) {
            devices = new ArrayList<BluetoothDeviceInfo>(this.mDiscoveredDeviceList);
        }
        object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.post(() -> {
                    for (BluetoothManagerCallback callback : this.mCallbacks) {
                        try {
                            callback.onDiscover(devices);
                        }
                        catch (Exception e) {
                            this.mCallbacks.remove(callback);
                            Log.w((String)TAG, (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callOnConnect(BluetoothDevice device) throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.isReleased()) {
                return;
            }
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.post(() -> {
                    for (BluetoothManagerCallback callback : this.mCallbacks) {
                        try {
                            callback.onConnect(device.getName(), device.getAddress());
                        }
                        catch (Exception e) {
                            this.mCallbacks.remove(callback);
                            Log.w((String)TAG, (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callOnDisConnect() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.isReleased()) {
                return;
            }
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.post(() -> {
                    for (BluetoothManagerCallback callback : this.mCallbacks) {
                        try {
                            callback.onDisconnect();
                        }
                        catch (Exception e) {
                            this.mCallbacks.remove(callback);
                            Log.w((String)TAG, (Throwable)e);
                        }
                    }
                });
            }
        }
        if (!this.isReleased()) {
            this.internalStartListen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callOnFailed() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.isReleased()) {
                return;
            }
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.post(() -> {
                    for (BluetoothManagerCallback callback : this.mCallbacks) {
                        try {
                            callback.onFailed();
                        }
                        catch (Exception e) {
                            this.mCallbacks.remove(callback);
                            Log.w((String)TAG, (Throwable)e);
                        }
                    }
                });
            }
        }
        if (!this.isReleased()) {
            this.internalStartListen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callOnReceive(byte[] message, int length) {
        byte[] msg = new byte[length];
        System.arraycopy(message, 0, msg, 0, length);
        Object object = this.mSync;
        synchronized (object) {
            if (this.isReleased()) {
                return;
            }
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.post(() -> {
                    for (BluetoothManagerCallback callback : this.mCallbacks) {
                        try {
                            callback.onReceive(msg, length);
                        }
                        catch (Exception e) {
                            this.mCallbacks.remove(callback);
                            Log.w((String)TAG, (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != -1) {
                this.mState = state;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnect(BluetoothSocket socket, BluetoothDevice device) {
        Object object = this.mSync;
        synchronized (object) {
            this.internalCancel(3, true);
            this.mReceiverThread = new ReceiverThread(socket);
            this.mReceiverThread.start();
            this.callOnConnect(device);
        }
    }

    private BluetoothSocket createBluetoothSocket(BluetoothDevice device, boolean secure) throws IOException {
        return secure ? device.createRfcommSocketToServiceRecord(this.mSecureProfileUUID) : device.createInsecureRfcommSocketToServiceRecord(this.mInSecureProfileUUID);
    }

    private class ConnectingThread
    extends BluetoothSocketThread {
        private final BluetoothDevice mmDevice;

        public ConnectingThread(BluetoothDevice device, boolean secure) throws IOException {
            super("ConnectingThread:" + BluetoothManager.this.mName, BluetoothManager.this.createBluetoothSocket(device, secure));
            this.mmDevice = device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (BluetoothManager.this.mAdapter.isDiscovering()) {
                BluetoothManager.this.mAdapter.cancelDiscovery();
            }
            try {
                this.mmSocket.connect();
            }
            catch (IOException e) {
                block8: {
                    Log.w((String)TAG, (Throwable)e);
                    try {
                        this.mmSocket.close();
                    }
                    catch (IOException e1) {
                        if (this.mIsCanceled) break block8;
                        Log.w((String)TAG, (String)"failed to close socket", (Throwable)e1);
                    }
                }
                BluetoothManager.this.callOnFailed();
                return;
            }
            Object object = BluetoothManager.this.mSync;
            synchronized (object) {
                BluetoothManager.this.mConnectingThread = null;
            }
            BluetoothManager.this.onConnect(this.mmSocket, this.mmDevice);
        }
    }

    private class ListeningThread
    extends Thread {
        private final BluetoothServerSocket mmServerSocket;
        private volatile boolean mIsCanceled;

        public ListeningThread(boolean secure) {
            super("ListeningThread:" + BluetoothManager.this.mName);
            BluetoothServerSocket tmp = null;
            try {
                tmp = secure ? BluetoothManager.this.mAdapter.listenUsingRfcommWithServiceRecord(BluetoothManager.this.mName, BluetoothManager.this.mSecureProfileUUID) : BluetoothManager.this.mAdapter.listenUsingInsecureRfcommWithServiceRecord(BluetoothManager.this.mName, BluetoothManager.this.mInSecureProfileUUID);
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mmServerSocket = tmp;
        }

        @Override
        public void run() {
            block8: while (BluetoothManager.this.mState != 3) {
                BluetoothSocket socket;
                try {
                    socket = this.mmServerSocket.accept();
                }
                catch (IOException e) {
                    if (this.mIsCanceled) break;
                    Log.d((String)TAG, (String)e.getMessage());
                    break;
                }
                if (socket == null) continue;
                switch (BluetoothManager.this.mState) {
                    case 1: 
                    case 2: {
                        BluetoothManager.this.onConnect(socket, socket.getRemoteDevice());
                        break block8;
                    }
                    case 0: 
                    case 3: {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"Could not close unwanted socket", (Throwable)e);
                        }
                    }
                    default: {
                        continue block8;
                    }
                }
            }
        }

        public void cancel() {
            this.mIsCanceled = true;
            try {
                this.mmServerSocket.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"close() of server failed", (Throwable)e);
            }
        }
    }

    private class ReceiverThread
    extends BluetoothSocketThread {
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        public ReceiverThread(BluetoothSocket socket) {
            super("ReceiverThread:" + BluetoothManager.this.mName, socket);
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"temp sockets not created", (Throwable)e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            while (BluetoothManager.this.mState == 3) {
                try {
                    int bytes = this.mmInStream.read(buffer);
                    if (bytes <= 0) continue;
                    BluetoothManager.this.callOnReceive(buffer, bytes);
                }
                catch (IOException e) {
                    if (!this.mIsCanceled) {
                        Log.d((String)TAG, (String)"disconnected", (Throwable)e);
                    }
                    BluetoothManager.this.callOnDisConnect();
                    break;
                }
            }
        }

        public void write(byte[] buffer) throws IllegalStateException {
            block3: {
                if (BluetoothManager.this.mState != 3) {
                    throw new IllegalStateException("already disconnected");
                }
                try {
                    this.mmOutStream.write(buffer);
                }
                catch (IOException e) {
                    if (this.mIsCanceled) break block3;
                    throw new IllegalStateException(e);
                }
            }
        }

        public void write(byte[] buffer, int offset, int len) throws IllegalStateException {
            block3: {
                if (BluetoothManager.this.mState != 3) {
                    throw new IllegalStateException("already disconnected");
                }
                try {
                    this.mmOutStream.write(buffer, offset, len);
                }
                catch (IOException e) {
                    if (this.mIsCanceled) break block3;
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private static abstract class BluetoothSocketThread
    extends Thread {
        protected final BluetoothSocket mmSocket;
        protected volatile boolean mIsCanceled;

        public BluetoothSocketThread(String name, BluetoothSocket socket) {
            super(name);
            this.mmSocket = socket;
        }

        public void cancel() {
            this.mIsCanceled = true;
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"failed to call BluetoothSocket#close", (Throwable)e);
            }
        }
    }

    public static interface BluetoothManagerCallback {
        public void onDiscover(Collection<BluetoothDeviceInfo> var1);

        public void onConnect(String var1, String var2);

        public void onDisconnect();

        public void onFailed();

        public void onReceive(byte[] var1, int var2);
    }
}

