/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import android.view.View;
import com.serenegiant.common.R;
import com.serenegiant.widget.IAspectRatioView;
import com.serenegiant.widget.IScaledView;
import com.serenegiant.widget.ITextureView;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class AspectScaledTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
IAspectRatioView,
IScaledView,
ITextureView {
    private static final String TAG = AspectScaledTextureView.class.getSimpleName();
    protected final Matrix mImageMatrix = new Matrix();
    private int mScaleMode = 0;
    private double mRequestedAspect = -1.0;
    private volatile boolean mHasSurface;
    private final Set<TextureView.SurfaceTextureListener> mListeners = new CopyOnWriteArraySet<TextureView.SurfaceTextureListener>();
    private int prevWidth = -1;
    private int prevHeight = -1;
    private TextureView.SurfaceTextureListener mSurfaceTextureListener;

    public AspectScaledTextureView(Context context) {
        this(context, null, 0);
    }

    public AspectScaledTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectScaledTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AspectScaledTextureView, defStyleAttr, 0);
        try {
            this.mRequestedAspect = a.getFloat(R.styleable.AspectScaledTextureView_aspect_ratio, -1.0f);
            this.mScaleMode = a.getInt(R.styleable.AspectScaledTextureView_scale_mode, 0);
        }
        finally {
            a.recycle();
        }
        super.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mRequestedAspect > 0.0 && this.mScaleMode == 0) {
            int vertPadding;
            int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int horizPadding = this.getPaddingLeft() + this.getPaddingRight();
            double viewAspectRatio = (double)(initialWidth -= horizPadding) / (double)(initialHeight -= (vertPadding = this.getPaddingTop() + this.getPaddingBottom()));
            double aspectDiff = this.mRequestedAspect / viewAspectRatio - 1.0;
            if (Math.abs(aspectDiff) > 0.01) {
                if (aspectDiff > 0.0) {
                    initialHeight = (int)((double)initialWidth / this.mRequestedAspect);
                } else {
                    initialWidth = (int)((double)initialHeight * this.mRequestedAspect);
                }
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizPadding), (int)0x40000000);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += vertPadding), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this.prevWidth != this.getWidth() || this.prevHeight != this.getHeight()) {
            this.prevWidth = this.getWidth();
            this.prevHeight = this.getHeight();
            this.onResize(this.prevWidth, this.prevHeight);
        }
        this.init();
    }

    public final void setSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        this.unregister(this.mSurfaceTextureListener);
        this.mSurfaceTextureListener = listener;
        this.register(listener);
    }

    @Override
    public void register(TextureView.SurfaceTextureListener listener) {
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    @Override
    public void unregister(TextureView.SurfaceTextureListener listener) {
        this.mListeners.remove(listener);
    }

    protected void onResize(int width, int height) {
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mHasSurface = true;
        this.init();
        for (TextureView.SurfaceTextureListener listener : this.mListeners) {
            try {
                listener.onSurfaceTextureAvailable(surface, width, height);
            }
            catch (Exception e) {
                this.mListeners.remove(listener);
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        for (TextureView.SurfaceTextureListener listener : this.mListeners) {
            try {
                listener.onSurfaceTextureSizeChanged(surface, width, height);
            }
            catch (Exception e) {
                this.mListeners.remove(listener);
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.mHasSurface = false;
        for (TextureView.SurfaceTextureListener listener : this.mListeners) {
            try {
                listener.onSurfaceTextureDestroyed(surface);
            }
            catch (Exception e) {
                this.mListeners.remove(listener);
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        for (TextureView.SurfaceTextureListener listener : this.mListeners) {
            try {
                listener.onSurfaceTextureUpdated(surface);
            }
            catch (Exception e) {
                this.mListeners.remove(listener);
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @Override
    public void setAspectRatio(double aspectRatio) {
        if (this.mRequestedAspect != aspectRatio) {
            this.mRequestedAspect = aspectRatio;
            this.requestLayout();
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestedAspect;
    }

    @Override
    public void setScaleMode(int scale_mode) {
        if (this.mScaleMode != scale_mode) {
            this.mScaleMode = scale_mode;
            this.requestLayout();
        }
    }

    @Override
    public int getScaleMode() {
        return this.mScaleMode;
    }

    protected void init() {
        int view_width = this.getWidth();
        int view_height = this.getHeight();
        this.mImageMatrix.reset();
        switch (this.mScaleMode) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                double video_width = this.mRequestedAspect * (double)view_height;
                double video_height = view_height;
                double scale_x = (double)view_width / video_width;
                double scale_y = (double)view_height / video_height;
                double scale = Math.max(scale_x, scale_y);
                double width = scale * video_width;
                double height = scale * video_height;
                this.mImageMatrix.postScale((float)(width / (double)view_width), (float)(height / (double)view_height), (float)(view_width / 2), (float)(view_height / 2));
            }
        }
        this.setTransform(this.mImageMatrix);
    }
}

