/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import com.serenegiant.media.MediaCodecHelper;
import com.serenegiant.media.TimeoutException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@TargetApi(value=16)
public abstract class MediaReaper
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaReaper.class.getSimpleName();
    public static final int REAPER_VIDEO = 0;
    public static final int REAPER_AUDIO = 1;
    public static final int TIMEOUT_USEC = 10000;
    private final Object mSync = new Object();
    private final WeakReference<MediaCodec> mWeakEncoder;
    private final ReaperListener mListener;
    private final int mReaperType;
    private MediaCodec.BufferInfo mBufferInfo;
    private volatile boolean mIsRunning;
    private volatile boolean mRecorderStarted;
    private boolean mRequestStop;
    private int mRequestDrain;
    private volatile boolean mIsEOS;
    private long prevOutputPTSUs = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaReaper(int reaperType, MediaCodec encoder, @NonNull ReaperListener listener) {
        this.mWeakEncoder = new WeakReference<MediaCodec>(encoder);
        this.mListener = listener;
        this.mReaperType = reaperType;
        this.mBufferInfo = new MediaCodec.BufferInfo();
        Object object = this.mSync;
        synchronized (object) {
            new Thread((Runnable)this, this.getClass().getSimpleName()).start();
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mIsRunning && !this.mRequestStop) {
            this.mRequestStop = true;
        }
        Object object = this.mSync;
        synchronized (object) {
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsRunning || this.mRequestStop) {
                return;
            }
            ++this.mRequestDrain;
            this.mSync.notifyAll();
        }
    }

    public int reaperType() {
        return this.mReaperType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Process.setThreadPriority((int)-4);
        Object object2 = this.mSync;
        synchronized (object2) {
            this.mIsRunning = true;
            this.mRequestStop = false;
            this.mRequestDrain = 0;
            this.mSync.notify();
        }
        while (this.mIsRunning) {
            boolean localRequestDrain;
            boolean localRequestStop;
            object = this.mSync;
            synchronized (object) {
                localRequestStop = this.mRequestStop;
                boolean bl = localRequestDrain = this.mRequestDrain > 0;
                if (localRequestDrain) {
                    --this.mRequestDrain;
                }
            }
            try {
                if (localRequestStop) {
                    this.drain();
                    this.mIsEOS = true;
                    this.release();
                    break;
                }
                if (localRequestDrain) {
                    this.drain();
                    continue;
                }
                object = this.mSync;
                synchronized (object) {
                    try {
                        this.mSync.wait(50L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            catch (IllegalStateException e) {
                break;
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        object = this.mSync;
        synchronized (object) {
            this.mRequestStop = true;
            this.mIsRunning = false;
        }
    }

    private final void drain() {
        ByteBuffer[] encoderOutputBuffers;
        MediaCodec encoder = (MediaCodec)this.mWeakEncoder.get();
        if (encoder == null) {
            return;
        }
        try {
            encoderOutputBuffers = encoder.getOutputBuffers();
        }
        catch (IllegalStateException e) {
            return;
        }
        int count = 0;
        while (this.mIsRunning) {
            int encoderStatus = encoder.dequeueOutputBuffer(this.mBufferInfo, 10000L);
            if (encoderStatus == -1) {
                if (this.mIsEOS || ++count <= 5) continue;
                break;
            }
            if (encoderStatus == -3) {
                encoderOutputBuffers = encoder.getOutputBuffers();
                continue;
            }
            if (encoderStatus == -2) {
                if (this.mRecorderStarted) {
                    throw new RuntimeException("format changed twice");
                }
                MediaFormat format = encoder.getOutputFormat();
                if (this.callOnFormatChanged(format)) continue;
                break;
            }
            if (encoderStatus < 0) continue;
            ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
            if (encodedData == null) {
                throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
            }
            if ((this.mBufferInfo.flags & 2) != 0) {
                if (!this.mRecorderStarted) {
                    byte[] tmp = new byte[this.mBufferInfo.size];
                    encodedData.position(0);
                    encodedData.get(tmp, this.mBufferInfo.offset, this.mBufferInfo.size);
                    encodedData.position(0);
                    int ix0 = MediaCodecHelper.findStartMarker(tmp, 0);
                    int ix1 = MediaCodecHelper.findStartMarker(tmp, ix0 + 2);
                    int ix2 = MediaCodecHelper.findStartMarker(tmp, ix1 + 2);
                    MediaFormat outFormat = this.createOutputFormat(tmp, this.mBufferInfo.size, ix0, ix1, ix2);
                    if (!this.callOnFormatChanged(outFormat)) break;
                }
                this.mBufferInfo.size = 0;
            }
            if (this.mBufferInfo.size != 0) {
                count = 0;
                if (!this.mRecorderStarted) {
                    throw new RuntimeException("drain:muxer hasn't started");
                }
                try {
                    this.mBufferInfo.presentationTimeUs = this.getNextOutputPTSUs(this.mBufferInfo.presentationTimeUs);
                    this.mListener.writeSampleData(this, encodedData, this.mBufferInfo);
                }
                catch (TimeoutException e) {
                    this.callOnError(e);
                }
                catch (Exception e) {
                    this.callOnError(e);
                }
            }
            encoder.releaseOutputBuffer(encoderStatus, false);
            if ((this.mBufferInfo.flags & 4) == 0) continue;
            this.callOnStop();
            break;
        }
    }

    protected abstract MediaFormat createOutputFormat(byte[] var1, int var2, int var3, int var4, int var5);

    private boolean callOnFormatChanged(MediaFormat format) {
        try {
            this.mListener.onOutputFormatChanged(this, format);
            this.mRecorderStarted = true;
            return true;
        }
        catch (Exception e) {
            this.callOnError(e);
            return false;
        }
    }

    private void callOnStop() {
        try {
            this.mListener.onStop(this);
        }
        catch (Exception e) {
            this.callOnError(e);
        }
    }

    private void callOnError(Exception e) {
        try {
            this.mListener.onError(this, e);
        }
        catch (Exception e1) {
            Log.w((String)TAG, (Throwable)e1);
        }
    }

    protected long getNextOutputPTSUs(long presentationTimeUs) {
        if (presentationTimeUs <= this.prevOutputPTSUs) {
            presentationTimeUs = this.prevOutputPTSUs + 9643L;
        }
        this.prevOutputPTSUs = presentationTimeUs;
        return presentationTimeUs;
    }

    public static class AudioReaper
    extends MediaReaper {
        private static final String MIME_TYPE = "audio/mp4a-latm";
        private final int mSampleRate;
        private final int mChannelCount;

        public AudioReaper(MediaCodec encoder, @NonNull ReaperListener listener, int sampleRate, int channelCount) {
            super(1, encoder, listener);
            this.mSampleRate = sampleRate;
            this.mChannelCount = channelCount;
        }

        @Override
        protected MediaFormat createOutputFormat(byte[] csd, int size, int ix0, int ix1, int ix2) {
            if (ix0 >= 0) {
                // empty if block
            }
            MediaFormat outFormat = MediaFormat.createAudioFormat((String)MIME_TYPE, (int)this.mSampleRate, (int)this.mChannelCount);
            ByteBuffer csd0 = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
            csd0.put(csd, 0, size);
            csd0.flip();
            outFormat.setByteBuffer("csd-0", csd0);
            return outFormat;
        }
    }

    public static class VideoReaper
    extends MediaReaper {
        public static final String MIME_AVC = "video/avc";
        private final int mWidth;
        private final int mHeight;

        public VideoReaper(MediaCodec encoder, @NonNull ReaperListener listener, int width, int height) {
            super(0, encoder, listener);
            this.mWidth = width;
            this.mHeight = height;
        }

        @Override
        protected MediaFormat createOutputFormat(byte[] csd, int size, int ix0, int ix1, int ix2) {
            MediaFormat outFormat;
            if (ix0 >= 0) {
                outFormat = MediaFormat.createVideoFormat((String)MIME_AVC, (int)this.mWidth, (int)this.mHeight);
                ByteBuffer csd0 = ByteBuffer.allocateDirect(ix1 - ix0).order(ByteOrder.nativeOrder());
                csd0.put(csd, ix0, ix1 - ix0);
                csd0.flip();
                outFormat.setByteBuffer("csd-0", csd0);
                if (ix1 > ix0) {
                    int sz = ix2 > ix1 ? ix2 - ix1 : size - ix1;
                    ByteBuffer csd1 = ByteBuffer.allocateDirect(sz).order(ByteOrder.nativeOrder());
                    csd1.put(csd, ix1, sz);
                    csd1.flip();
                    outFormat.setByteBuffer("csd-1", csd1);
                }
            } else {
                throw new RuntimeException("unexpected csd data came.");
            }
            return outFormat;
        }
    }

    public static interface ReaperListener {
        public void writeSampleData(@NonNull MediaReaper var1, ByteBuffer var2, MediaCodec.BufferInfo var3);

        public void onOutputFormatChanged(@NonNull MediaReaper var1, @NonNull MediaFormat var2);

        public void onStop(@NonNull MediaReaper var1);

        public void onError(@NonNull MediaReaper var1, Exception var2);
    }
}

