/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaFormat;
import android.os.Bundle;
import com.serenegiant.media.AbstractEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.IVideoEncoder;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.utils.BuildCheck;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@TargetApi(value=16)
public abstract class AbstractVideoEncoder
extends AbstractEncoder
implements IVideoEncoder {
    protected int mWidth;
    protected int mHeight;
    protected int mBitRate = -1;
    protected int mFramerate = -1;
    protected int mIFrameIntervals = -1;
    public static boolean supportsAdaptiveStreaming = BuildCheck.isKitKat();

    public AbstractVideoEncoder(String mime, IRecorder recorder, EncoderListener listener) {
        super(mime, recorder, listener);
    }

    @Override
    public void setVideoSize(int width, int height) throws IllegalArgumentException, IllegalStateException {
        this.mWidth = width;
        this.mHeight = height;
        this.mBitRate = VideoConfig.getBitrate(width, height);
    }

    public void setVideoConfig(int bitRate, int frameRate, int iFrameIntervals) {
        this.mBitRate = bitRate;
        this.mFramerate = frameRate;
        this.mIFrameIntervals = iFrameIntervals;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public final boolean isAudio() {
        return false;
    }

    @TargetApi(value=19)
    public void adjustBitrate(int targetBitrate) {
        if (supportsAdaptiveStreaming && this.mMediaCodec != null) {
            Bundle bitrate = new Bundle();
            bitrate.putInt("video-bitrate", targetBitrate);
            this.mMediaCodec.setParameters(bitrate);
        } else if (!supportsAdaptiveStreaming) {
            // empty if block
        }
    }

    @Override
    protected MediaFormat createOutputFormat(byte[] csd, int size, int ix0, int ix1, int ix2) {
        MediaFormat outFormat;
        if (ix0 >= 0) {
            outFormat = MediaFormat.createVideoFormat((String)this.MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
            ByteBuffer csd0 = ByteBuffer.allocateDirect(ix1 - ix0).order(ByteOrder.nativeOrder());
            csd0.put(csd, ix0, ix1 - ix0);
            csd0.flip();
            outFormat.setByteBuffer("csd-0", csd0);
            if (ix1 > ix0) {
                int sz = ix2 > ix1 ? ix2 - ix1 : size - ix1;
                ByteBuffer csd1 = ByteBuffer.allocateDirect(size - ix1 + ix0).order(ByteOrder.nativeOrder());
                csd1.put(csd, ix1, size - ix1 + ix0);
                csd1.flip();
                outFormat.setByteBuffer("csd-1", csd1);
            }
        } else {
            throw new RuntimeException("unexpected csd data came.");
        }
        return outFormat;
    }
}

