/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils.es1;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.opengl.GLES10;
import android.opengl.GLES30;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import android.util.Log;
import com.serenegiant.utils.BuildCheck;
import javax.microedition.khronos.opengles.GL10;

public final class GLHelper {
    private static final String TAG = "GLHelper";
    private static final float[] sScratch = new float[32];

    public static void checkGlError(String op) {
        int error = GLES10.glGetError();
        if (error != 0) {
            String msg = op + ": glError 0x" + Integer.toHexString(error);
            Log.e((String)TAG, (String)msg);
            new Throwable(msg).printStackTrace();
        }
    }

    public static void checkGlError(GL10 gl, String op) {
        int error = gl.glGetError();
        if (error != 0) {
            String msg = op + ": glError 0x" + Integer.toHexString(error);
            Log.e((String)TAG, (String)msg);
            new Throwable(msg).printStackTrace();
        }
    }

    public static int initTex(int texTarget, int filter_param) {
        return GLHelper.initTex(texTarget, 33984, filter_param, filter_param, 33071);
    }

    public static int initTex(int texTarget, int texUnit, int min_filter, int mag_filter, int wrap) {
        int[] tex = new int[1];
        GLES10.glActiveTexture((int)texUnit);
        GLES10.glGenTextures((int)1, (int[])tex, (int)0);
        GLES10.glBindTexture((int)texTarget, (int)tex[0]);
        GLES10.glTexParameterx((int)texTarget, (int)10242, (int)wrap);
        GLES10.glTexParameterx((int)texTarget, (int)10243, (int)wrap);
        GLES10.glTexParameterx((int)texTarget, (int)10241, (int)min_filter);
        GLES10.glTexParameterx((int)texTarget, (int)10240, (int)mag_filter);
        return tex[0];
    }

    public static int initTex(GL10 gl, int texTarget, int filter_param) {
        int[] tex = new int[1];
        gl.glActiveTexture(33984);
        gl.glGenTextures(1, tex, 0);
        gl.glBindTexture(texTarget, tex[0]);
        gl.glTexParameterx(texTarget, 10242, 33071);
        gl.glTexParameterx(texTarget, 10243, 33071);
        gl.glTexParameterx(texTarget, 10241, filter_param);
        gl.glTexParameterx(texTarget, 10240, filter_param);
        return tex[0];
    }

    public static void deleteTex(int hTex) {
        int[] tex = new int[]{hTex};
        GLES10.glDeleteTextures((int)1, (int[])tex, (int)0);
    }

    public static void deleteTex(GL10 gl, int hTex) {
        int[] tex = new int[]{hTex};
        gl.glDeleteTextures(1, tex, 0);
    }

    public static int loadTextureFromResource(Context context, int resId) {
        Bitmap bitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 255, 0);
        Drawable background = context.getResources().getDrawable(resId);
        background.setBounds(0, 0, 256, 256);
        background.draw(canvas);
        int[] textures = new int[1];
        GLES10.glGenTextures((int)1, (int[])textures, (int)0);
        GLES10.glBindTexture((int)3553, (int)textures[0]);
        GLES10.glTexParameterx((int)3553, (int)10241, (int)9728);
        GLES10.glTexParameterx((int)3553, (int)10240, (int)9729);
        GLES10.glTexParameterx((int)3553, (int)10242, (int)10497);
        GLES10.glTexParameterx((int)3553, (int)10243, (int)10497);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        bitmap.recycle();
        return textures[0];
    }

    public static int createTextureWithTextContent(String text) {
        Bitmap bitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 255, 0);
        Paint textPaint = new Paint();
        textPaint.setTextSize(32.0f);
        textPaint.setAntiAlias(true);
        textPaint.setARGB(255, 255, 255, 255);
        canvas.drawText(text, 16.0f, 112.0f, textPaint);
        int texture = GLHelper.initTex(3553, 33984, 9728, 9729, 10497);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        bitmap.recycle();
        return texture;
    }

    public static void checkLocation(int location, String label) {
        if (location < 0) {
            throw new RuntimeException("Unable to locate '" + label + "' in program");
        }
    }

    @SuppressLint(value={"InlinedApi"})
    public static void logVersionInfo() {
        Log.i((String)TAG, (String)("vendor  : " + GLES10.glGetString((int)7936)));
        Log.i((String)TAG, (String)("renderer: " + GLES10.glGetString((int)7937)));
        Log.i((String)TAG, (String)("version : " + GLES10.glGetString((int)7938)));
        if (BuildCheck.isAndroid4_3()) {
            int[] values = new int[1];
            GLES30.glGetIntegerv((int)33307, (int[])values, (int)0);
            int majorVersion = values[0];
            GLES30.glGetIntegerv((int)33308, (int[])values, (int)0);
            int minorVersion = values[0];
            if (GLES30.glGetError() == 0) {
                Log.i((String)TAG, (String)("version: " + majorVersion + "." + minorVersion));
            }
        }
    }

    public static String gluErrorString(int error) {
        switch (error) {
            case 0: {
                return "no error";
            }
            case 1280: {
                return "invalid enum";
            }
            case 1281: {
                return "invalid value";
            }
            case 1282: {
                return "invalid operation";
            }
            case 1283: {
                return "stack overflow";
            }
            case 1284: {
                return "stack underflow";
            }
            case 1285: {
                return "out of memory";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gluLookAt(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float[] scratch;
        float[] fArray = scratch = sScratch;
        synchronized (scratch) {
            Matrix.setLookAtM((float[])scratch, (int)0, (float)eyeX, (float)eyeY, (float)eyeZ, (float)centerX, (float)centerY, (float)centerZ, (float)upX, (float)upY, (float)upZ);
            GLES10.glMultMatrixf((float[])scratch, (int)0);
            // ** MonitorExit[var10_10] (shouldn't be in output)
            return;
        }
    }

    public static void gluOrtho2D(float left, float right, float bottom, float top) {
        GLES10.glOrthof((float)left, (float)right, (float)bottom, (float)top, (float)-1.0f, (float)1.0f);
    }

    public static void gluPerspective(float fovy, float aspect, float zNear, float zFar) {
        float top = zNear * (float)Math.tan((double)fovy * (Math.PI / 360));
        float bottom = -top;
        float left = bottom * aspect;
        float right = top * aspect;
        GLES10.glFrustumf((float)left, (float)right, (float)bottom, (float)top, (float)zNear, (float)zFar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluProject(float objX, float objY, float objZ, float[] model, int modelOffset, float[] project, int projectOffset, int[] view, int viewOffset, float[] win, int winOffset) {
        float[] scratch;
        float[] fArray = scratch = sScratch;
        synchronized (scratch) {
            boolean M_OFFSET = false;
            int V_OFFSET = 16;
            int V2_OFFSET = 20;
            Matrix.multiplyMM((float[])scratch, (int)0, (float[])project, (int)projectOffset, (float[])model, (int)modelOffset);
            scratch[16] = objX;
            scratch[17] = objY;
            scratch[18] = objZ;
            scratch[19] = 1.0f;
            Matrix.multiplyMV((float[])scratch, (int)20, (float[])scratch, (int)0, (float[])scratch, (int)16);
            float w = scratch[23];
            if (w == 0.0f) {
                // ** MonitorExit[var12_12] (shouldn't be in output)
                return 0;
            }
            float rw = 1.0f / w;
            win[winOffset] = (float)view[viewOffset] + (float)view[viewOffset + 2] * (scratch[20] * rw + 1.0f) * 0.5f;
            win[winOffset + 1] = (float)view[viewOffset + 1] + (float)view[viewOffset + 3] * (scratch[21] * rw + 1.0f) * 0.5f;
            win[winOffset + 2] = (scratch[22] * rw + 1.0f) * 0.5f;
            // ** MonitorExit[var12_12] (shouldn't be in output)
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluUnProject(float winX, float winY, float winZ, float[] model, int modelOffset, float[] project, int projectOffset, int[] view, int viewOffset, float[] obj, int objOffset) {
        float[] scratch;
        float[] fArray = scratch = sScratch;
        synchronized (scratch) {
            boolean PM_OFFSET = false;
            int INVPM_OFFSET = 16;
            boolean V_OFFSET = false;
            Matrix.multiplyMM((float[])scratch, (int)0, (float[])project, (int)projectOffset, (float[])model, (int)modelOffset);
            if (!Matrix.invertM((float[])scratch, (int)16, (float[])scratch, (int)0)) {
                // ** MonitorExit[var12_12] (shouldn't be in output)
                return 0;
            }
            scratch[0] = 2.0f * (winX - (float)view[viewOffset + 0]) / (float)view[viewOffset + 2] - 1.0f;
            scratch[1] = 2.0f * (winY - (float)view[viewOffset + 1]) / (float)view[viewOffset + 3] - 1.0f;
            scratch[2] = 2.0f * winZ - 1.0f;
            scratch[3] = 1.0f;
            Matrix.multiplyMV((float[])obj, (int)objOffset, (float[])scratch, (int)16, (float[])scratch, (int)0);
            // ** MonitorExit[var12_12] (shouldn't be in output)
            return 1;
        }
    }
}

